/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.interposition.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std.interposition;

/**
 * Information about an interposed request for operation invocation. All
 * interposers would receive an instance of this structure as an input parameter.
 */
public final class InvocationRequest implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String serviceId;

    private java.lang.String operationId;

    private com.vmware.vapi.data.DataValue operationInput;

    private com.vmware.vapi.std.interposition.SecurityPrincipal user;

    private java.util.List<com.vmware.vapi.std.interposition.SecurityPrincipal> groups;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
     */
    public InvocationRequest(java.lang.String serviceId, java.lang.String operationId, com.vmware.vapi.data.DataValue operationInput, com.vmware.vapi.std.interposition.SecurityPrincipal user, java.util.List<com.vmware.vapi.std.interposition.SecurityPrincipal> groups) {
        this();
        this.serviceId = serviceId;
        this.operationId = operationId;
        this.operationInput = operationInput;
        this.user = user;
        this.groups = groups;
    }

    /**
     * Default constructor.
     */
    public InvocationRequest() {
    }

    protected InvocationRequest(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Fully qualified name of the service which contains the interposed operation. In
     * canonical format. For example org.example.hello.
     *
     * @return The current value of the property.
     */
    public java.lang.String getServiceId() {
        return this.serviceId;
    }

    /**
     * Fully qualified name of the service which contains the interposed operation. In
     * canonical format. For example org.example.hello.
     *
     * @param serviceId New value for the property.
     */
    public void setServiceId(java.lang.String serviceId) {
        this.serviceId = serviceId;
    }

    /**
     * Name of the interposed operation. In canonical format. For example say_hello.
     *
     * @return The current value of the property.
     */
    public java.lang.String getOperationId() {
        return this.operationId;
    }

    /**
     * Name of the interposed operation. In canonical format. For example say_hello.
     *
     * @param operationId New value for the property.
     */
    public void setOperationId(java.lang.String operationId) {
        this.operationId = operationId;
    }

    /**
     * Input of the interposed operation.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.data.DataValue getOperationInput() {
        return this.operationInput;
    }

    /**
     * Input of the interposed operation.
     *
     * @param operationInput New value for the property.
     */
    public void setOperationInput(com.vmware.vapi.data.DataValue operationInput) {
        this.operationInput = operationInput;
    }

    /**
     * User which started the interposed operation.
     *
     * There could be no authentication information. For example when methods are
     * invoked anonymously.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.std.interposition.SecurityPrincipal getUser() {
        return this.user;
    }

    /**
     * User which started the interposed operation.
     *
     * There could be no authentication information. For example when methods are
     * invoked anonymously.
     *
     * @param user New value for the property.
     */
    public void setUser(com.vmware.vapi.std.interposition.SecurityPrincipal user) {
        this.user = user;
    }

    /**
     * Groups of the user who started the interposed operation. Would be empty if there
     * is no authentication information.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.vapi.std.interposition.SecurityPrincipal> getGroups() {
        return this.groups;
    }

    /**
     * Groups of the user who started the interposed operation. Would be empty if there
     * is no authentication information.
     *
     * @param groups New value for the property.
     */
    public void setGroups(java.util.List<com.vmware.vapi.std.interposition.SecurityPrincipal> groups) {
        this.groups = groups;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.vapi.std.interposition.StructDefinitions.invocationRequest;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("service_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.serviceId, this._getType().getField("service_id")));
        structValue.setField("operation_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.operationId, this._getType().getField("operation_id")));
        structValue.setField("operation_input",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.operationInput, this._getType().getField("operation_input")));
        structValue.setField("user",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.user, this._getType().getField("user")));
        structValue.setField("groups",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groups, this._getType().getField("groups")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.vapi.std.interposition.StructDefinitions.invocationRequest;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.interposition.StructDefinitions.invocationRequest.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static InvocationRequest _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new InvocationRequest(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static InvocationRequest _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new InvocationRequest(structValue);
    }

    /**
     * Builder class for {@link InvocationRequest}.
     */
    public static final class Builder {
        private java.lang.String serviceId;
        private java.lang.String operationId;
        private com.vmware.vapi.data.DataValue operationInput;
        private com.vmware.vapi.std.interposition.SecurityPrincipal user;
        private java.util.List<com.vmware.vapi.std.interposition.SecurityPrincipal> groups;

        /**
         * Constructor with parameters for the required properties of
         * {@link InvocationRequest}.
         */
        public Builder(java.lang.String serviceId, java.lang.String operationId, com.vmware.vapi.data.DataValue operationInput, java.util.List<com.vmware.vapi.std.interposition.SecurityPrincipal> groups) {
            this.serviceId = serviceId;
            this.operationId = operationId;
            this.operationInput = operationInput;
            this.groups = groups;
        }

        /**
         * User which started the interposed operation.
         *
         * There could be no authentication information. For example when methods are
         * invoked anonymously.
         *
         * @param user New value for the property.
         */
        public Builder setUser(com.vmware.vapi.std.interposition.SecurityPrincipal user) {
            this.user = user;
            return this;
        }

        public InvocationRequest build() {
            InvocationRequest result = new InvocationRequest();
            result.setServiceId(this.serviceId);
            result.setOperationId(this.operationId);
            result.setOperationInput(this.operationInput);
            result.setUser(this.user);
            result.setGroups(this.groups);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("service_id", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("service_id",
                                                                                "serviceId",
                                                                                "getServiceId",
                                                                                "setServiceId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("operation_id", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("operation_id",
                                                                                "operationId",
                                                                                "getOperationId",
                                                                                "setOperationId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("operation_input", new com.vmware.vapi.bindings.type.OpaqueType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("operation_input",
                                                                                "operationInput",
                                                                                "getOperationInput",
                                                                                "setOperationInput");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("user", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.interposition.StructDefinitions.securityPrincipal; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("user",
                                                                                "user",
                                                                                "getUser",
                                                                                "setUser");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("groups", new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.interposition.StructDefinitions.securityPrincipal; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("groups",
                                                                                "groups",
                                                                                "getGroups",
                                                                                "setGroups");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.interposition.invocation_request",
                                                            fields,
                                                            com.vmware.vapi.std.interposition.InvocationRequest.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

