/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 */

package com.vmware.vapi.std.introspection;

/**
 * Implementation of {@link com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton} which
 * adapts API service implementation (class that implements
 * the generated {@link com.vmware.vapi.std.introspection.OperationProvider} interface).
 *
 * <p>This adapter expects asynchronous/non-blocking API service implementation.</p>
 */
public class OperationApiInterface extends com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton {
    private com.vmware.vapi.std.introspection.OperationProvider impl;

    private class ListApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public ListApiMethod() {
            super(OperationApiInterface.this.getIdentifier(),
                  "list",
                  com.vmware.vapi.std.introspection.OperationDefinitions.__listInput,
                  com.vmware.vapi.std.introspection.OperationDefinitions.__listOutput,
                  getTypeConverter(),
                  java.util.Arrays.<com.vmware.vapi.bindings.type.Type>asList(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.errors.StructDefinitions.notFound; } }),
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            com.vmware.vapi.internal.bindings.StructValueExtractor extr =
                    new com.vmware.vapi.internal.bindings.StructValueExtractor(inStruct,
                                                                               com.vmware.vapi.std.introspection.OperationDefinitions.__listInput,
                                                                               getTypeConverter());
            java.lang.String serviceId = extr.<java.lang.String>valueForField("service_id");
            impl.list(serviceId, new com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl<java.util.Set<java.lang.String>>(getTypeConverter(),com.vmware.vapi.std.introspection.OperationDefinitions.__listOutput, invocationContext, asyncHandle, this));
        }
    }

    private class GetApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public GetApiMethod() {
            super(OperationApiInterface.this.getIdentifier(),
                  "get",
                  com.vmware.vapi.std.introspection.OperationDefinitions.__getInput,
                  com.vmware.vapi.std.introspection.OperationDefinitions.__getOutput,
                  getTypeConverter(),
                  java.util.Arrays.<com.vmware.vapi.bindings.type.Type>asList(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.errors.StructDefinitions.notFound; } }),
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            com.vmware.vapi.internal.bindings.StructValueExtractor extr =
                    new com.vmware.vapi.internal.bindings.StructValueExtractor(inStruct,
                                                                               com.vmware.vapi.std.introspection.OperationDefinitions.__getInput,
                                                                               getTypeConverter());
            java.lang.String serviceId = extr.<java.lang.String>valueForField("service_id");
            java.lang.String operationId = extr.<java.lang.String>valueForField("operation_id");
            impl.get(serviceId, operationId, new com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl<com.vmware.vapi.std.introspection.OperationTypes.Info>(getTypeConverter(),com.vmware.vapi.std.introspection.OperationDefinitions.__getOutput, invocationContext, asyncHandle, this));
        }
    }

    /**
     * Constructor.
     *
     * Creates an {@link OperationApiInterface} instance with
     * default API service implementation.
     * <p>
     * The default service implementation is assumed to be
     * instance of the {@code com.vmware.vapi.std.introspection.impl.OperationImpl} class. This
     * class will be loaded and instantiated.
     */
    public OperationApiInterface() {
        this((java.lang.Class<com.vmware.vapi.std.introspection.OperationProvider>) null);
    }

    /**
     * Constructor.
     *
     * Creates an {@link OperationApiInterface} instance
     * for specified {@code class} of the API service implementation. The
     * specified class will be instantiated.
     *
     * @param implClass The {@code Class} implementing {@link com.vmware.vapi.std.introspection.OperationProvider}
     *                  API service. If {@code null} default implementation will be
     *                  used as in {@link #OperationApiInterface()}.
     */
    public OperationApiInterface(java.lang.Class<? extends com.vmware.vapi.std.introspection.OperationProvider> implClass) {
        this(createImplInstance(implClass,
                                "com.vmware.vapi.std.introspection.impl.OperationImpl",
                                com.vmware.vapi.std.introspection.OperationProvider.class));
    }

    /**
     * Constructor.
     *
     * Creates an {@link OperationApiInterface} instance
     * for specified instance of the API service implementation.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.OperationProvider}
     *             API service. Must not be {@code null}.
     */
    public OperationApiInterface(com.vmware.vapi.std.introspection.OperationProvider impl) {
        this(impl,  new com.vmware.vapi.internal.bindings.TypeConverterImpl());
    }

    /**
     * Constructor.
     *
     * Creates an {@link OperationApiInterface} instance
     * for specified instance of the API service implementation and custom conversion logic.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.OperationProvider}
     *             API service. Must not be {@code null}.
     * @param converter logic to convert from native to wire type and back. Must not be {@code null}.
     */
    public OperationApiInterface(com.vmware.vapi.std.introspection.OperationProvider impl,
            com.vmware.vapi.internal.bindings.TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.operation", converter);

        com.vmware.vapi.internal.util.Validate.notNull(impl);
        this.impl = impl;

        registerMethod(new ListApiMethod());
        registerMethod(new GetApiMethod());
    }
}
