/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 */

package com.vmware.vapi.std.introspection;

/**
 * Implementation of {@link com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton} which
 * adapts API service implementation (class that implements
 * the generated {@link com.vmware.vapi.std.introspection.ProviderProvider} interface).
 *
 * <p>This adapter expects asynchronous/non-blocking API service implementation.</p>
 */
public class ProviderApiInterface extends com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton {
    private com.vmware.vapi.std.introspection.ProviderProvider impl;

    private class GetApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public GetApiMethod() {
            super(ProviderApiInterface.this.getIdentifier(),
                  "get",
                  com.vmware.vapi.std.introspection.ProviderDefinitions.__getInput,
                  com.vmware.vapi.std.introspection.ProviderDefinitions.__getOutput,
                  getTypeConverter(),
                  null,
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            impl.get(new com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl<com.vmware.vapi.std.introspection.ProviderTypes.Info>(getTypeConverter(),com.vmware.vapi.std.introspection.ProviderDefinitions.__getOutput, invocationContext, asyncHandle, this));
        }
    }

    /**
     * Constructor.
     *
     * Creates an {@link ProviderApiInterface} instance with
     * default API service implementation.
     * <p>
     * The default service implementation is assumed to be
     * instance of the {@code com.vmware.vapi.std.introspection.impl.ProviderImpl} class. This
     * class will be loaded and instantiated.
     */
    public ProviderApiInterface() {
        this((java.lang.Class<com.vmware.vapi.std.introspection.ProviderProvider>) null);
    }

    /**
     * Constructor.
     *
     * Creates an {@link ProviderApiInterface} instance
     * for specified {@code class} of the API service implementation. The
     * specified class will be instantiated.
     *
     * @param implClass The {@code Class} implementing {@link com.vmware.vapi.std.introspection.ProviderProvider}
     *                  API service. If {@code null} default implementation will be
     *                  used as in {@link #ProviderApiInterface()}.
     */
    public ProviderApiInterface(java.lang.Class<? extends com.vmware.vapi.std.introspection.ProviderProvider> implClass) {
        this(createImplInstance(implClass,
                                "com.vmware.vapi.std.introspection.impl.ProviderImpl",
                                com.vmware.vapi.std.introspection.ProviderProvider.class));
    }

    /**
     * Constructor.
     *
     * Creates an {@link ProviderApiInterface} instance
     * for specified instance of the API service implementation.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.ProviderProvider}
     *             API service. Must not be {@code null}.
     */
    public ProviderApiInterface(com.vmware.vapi.std.introspection.ProviderProvider impl) {
        this(impl,  new com.vmware.vapi.internal.bindings.TypeConverterImpl());
    }

    /**
     * Constructor.
     *
     * Creates an {@link ProviderApiInterface} instance
     * for specified instance of the API service implementation and custom conversion logic.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.ProviderProvider}
     *             API service. Must not be {@code null}.
     * @param converter logic to convert from native to wire type and back. Must not be {@code null}.
     */
    public ProviderApiInterface(com.vmware.vapi.std.introspection.ProviderProvider impl,
            com.vmware.vapi.internal.bindings.TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.provider", converter);

        com.vmware.vapi.internal.util.Validate.notNull(impl);
        this.impl = impl;

        registerMethod(new GetApiMethod());
    }
}
