
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 */

package com.vmware.vapi.std.introspection;

/**
 * Implementation of {@link com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton} which
 * adapts API service implementation (class that implements
 * the generated {@link com.vmware.vapi.std.introspection.ProviderSyncProvider} interface).
 *
 * <p>This adapter expects synchronous API service implementation.</p>
 */
public class ProviderSyncApiInterface extends com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton {
    private com.vmware.vapi.std.introspection.ProviderSyncProvider impl;

    private class GetApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public GetApiMethod() {
            super(ProviderSyncApiInterface.this.getIdentifier(),
                  "get", com.vmware.vapi.std.introspection.ProviderDefinitions.__getInput,
                  com.vmware.vapi.std.introspection.ProviderDefinitions.__getOutput,
                  getTypeConverter(),
                  null,
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newResult(getTypeConverter().convertToVapi(impl.get(invocationContext),
                                                                                                                   com.vmware.vapi.std.introspection.ProviderDefinitions.__getOutput,
                                                                                                                   new com.vmware.vapi.internal.bindings.TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            } catch (java.lang.RuntimeException ex) {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newErrorResult(toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }

    /**
     * Constructor.
     *
     * Creates an {@link ProviderSyncApiInterface} instance with
     * default API service implementation.
     * <p>
     * The default service implementation is assumed to be
     * instance of the {@code com.vmware.vapi.std.introspection.impl.ProviderImpl} class. This
     * class will be loaded and instantiated.
     */
    public ProviderSyncApiInterface() {
        this((java.lang.Class<com.vmware.vapi.std.introspection.ProviderSyncProvider>) null);
    }

    /**
     * Constructor.
     *
     * Creates an {@link ProviderSyncApiInterface} instance
     * for specified {@code class} of the API service implementation. The
     * specified class will be instantiated.
     *
     * @param implClass The {@code Class} implementing {@link com.vmware.vapi.std.introspection.ProviderSyncProvider}
     *                  API service. If {@code null} default implementation will be
     *                  used as in {@link #ProviderSyncApiInterface()}.
     */
    public ProviderSyncApiInterface(java.lang.Class<? extends com.vmware.vapi.std.introspection.ProviderSyncProvider> implClass) {
        this(createImplInstance(implClass,
                                "com.vmware.vapi.std.introspection.impl.ProviderImpl",
                                com.vmware.vapi.std.introspection.ProviderSyncProvider.class));
    }

    /**
     * Constructor.
     *
     * Creates an {@link ProviderSyncApiInterface} instance
     * for specified instance of the API service implementation.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.ProviderSyncProvider}
     *             API service. Must not be {@code null}.
     */
    public ProviderSyncApiInterface(com.vmware.vapi.std.introspection.ProviderSyncProvider impl) {
        this(impl,  new com.vmware.vapi.internal.bindings.TypeConverterImpl());
    }

    /**
     * Constructor.
     *
     * Creates an {@link ProviderSyncApiInterface} instance
     * for specified instance of the API service implementation and custom conversion logic.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.ProviderSyncProvider}
     *             API service. Must not be {@code null}.
     * @param converter logic to convert from native to wire type and back. Must not be {@code null}.
     */
    public ProviderSyncApiInterface(com.vmware.vapi.std.introspection.ProviderSyncProvider impl,
            com.vmware.vapi.internal.bindings.TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.provider", converter);

        com.vmware.vapi.internal.util.Validate.notNull(impl);
        this.impl = impl;

        registerMethod(new GetApiMethod());
   }
}

