/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 * Contains only data type definitions and no methods.
 * Shared by client-side stubs and server-side skeletons to ensure type
 * compatibility.
 */

package com.vmware.vapi.std.introspection;

/**
 * Defines the data types of the {@link Provider}
 * API service.
 */
/**
 * The {@link com.vmware.vapi.std.introspection.Provider} service provides
 * operations to retrieve information about a vAPI Provider. A provider is a
 * container that exposes one or more vAPI services.
 */
public interface ProviderTypes {
    /**
     * Identifier of the service
     */
    public static final String _VAPI_SERVICE_ID = "com.vmware.vapi.std.introspection.provider";

    /**
     * Information about a vAPI provider
     */
    public static final class Info implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

        private static final long serialVersionUID = 1L;

        private java.lang.String id;

        private java.lang.String checksum;

        protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

        /**
         * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
         */
        public Info(java.lang.String id, java.lang.String checksum) {
            this();
            this.id = id;
            this.checksum = checksum;
        }

        /**
         * Default constructor.
         */
        public Info() {
        }

        protected Info(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
            this.__dynamicStructureFields = __dynamicStructureFields;
        }


        /**
         * Identifier of the provider
         *
         * @return The current value of the property.
         * When clients pass a value of this class as a parameter, the property must be an
         * identifier for the resource type: {@code com.vmware.vapi.provider}. When methods
         * return a value of this class as a return value, the property will be an
         * identifier for the resource type: {@code com.vmware.vapi.provider}.
         */
        public java.lang.String getId() {
            return this.id;
        }

        /**
         * Identifier of the provider
         *
         * @param id New value for the property.
         * When clients pass a value of this class as a parameter, the property must be an
         * identifier for the resource type: {@code com.vmware.vapi.provider}. When methods
         * return a value of this class as a return value, the property will be an
         * identifier for the resource type: {@code com.vmware.vapi.provider}.
         */
        public void setId(java.lang.String id) {
            this.id = id;
        }

        /**
         * Checksum of the information present in the provider. 
         * <p> Clients can use this
         * information to check if the service information has changed. When a new service
         * is added or removed (or) one of the existing service information is modified,
         * the value of the checksum changes. </p>
         * <p> The information used to calculate
         * the checksum includes: </p><ul> <li>service identifiers</li> <li>operation
         * identifiers inside the service</li> <li>input, output and error definitions of
         * an operation</li> </ul>
         *
         * @return The current value of the property.
         */
        public java.lang.String getChecksum() {
            return this.checksum;
        }

        /**
         * Checksum of the information present in the provider. 
         * <p> Clients can use this
         * information to check if the service information has changed. When a new service
         * is added or removed (or) one of the existing service information is modified,
         * the value of the checksum changes. </p>
         * <p> The information used to calculate
         * the checksum includes: </p><ul> <li>service identifiers</li> <li>operation
         * identifiers inside the service</li> <li>input, output and error definitions of
         * an operation</li> </ul>
         *
         * @param checksum New value for the property.
         */
        public void setChecksum(java.lang.String checksum) {
            this.checksum = checksum;
        }

       @java.lang.Override
        public com.vmware.vapi.bindings.type.StructType _getType() {
            return com.vmware.vapi.std.introspection.ProviderDefinitions.info;
        }

        @java.lang.Override
        public com.vmware.vapi.data.StructValue _getDataValue() {
            com.vmware.vapi.data.StructValue dataValue;
            if (__dynamicStructureFields != null) {
                dataValue = __dynamicStructureFields.copy();
            } else {
                dataValue = createEmptyStructValue();
            }
            this._updateDataValue(dataValue);
            return dataValue;
        }

        protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
            structValue.setField("id",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.id, this._getType().getField("id")));
            structValue.setField("checksum",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.checksum, this._getType().getField("checksum")));
        }

        @java.lang.Override
        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        @java.lang.Override
        public boolean equals(java.lang.Object obj) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
        }

        @java.lang.Override
        public int hashCode() {
            return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
        }

        @java.lang.Override
        public java.lang.String toString() {
            return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
        }

        @java.lang.Override
        public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
        }

        @java.lang.Override
        public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
        }

        @java.lang.Override
        public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
            if (_getType().getFieldNames().contains(fieldName)) {
                 throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
            }
            if(__dynamicStructureFields == null) {
                __dynamicStructureFields = createEmptyStructValue();
            }
            __dynamicStructureFields.setField(fieldName, fieldValue);
        }

        @java.lang.Override
        public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
            if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
                throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
            }
            return __dynamicStructureFields.getField(fieldName);
        }

        @java.lang.Override
        public java.util.Set<java.lang.String> _getDynamicFieldNames() {
            if (__dynamicStructureFields == null) {
                return java.util.Collections.<java.lang.String>emptySet();
            }
            return __dynamicStructureFields.getFieldNames();
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.
         *
         * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
         * type for this <code>Structure</code>.
         */
        public static com.vmware.vapi.bindings.type.StructType _getClassType() {
            return com.vmware.vapi.std.introspection.ProviderDefinitions.info;
        }

        @java.lang.Override
        public java.lang.String _getCanonicalName() {
            if (__dynamicStructureFields != null) {
                return __dynamicStructureFields.getName();
            }
            return com.vmware.vapi.std.introspection.ProviderDefinitions.info.getName();
        }

        /**
         * Returns the canonical type name. See {@link #_getCanonicalName()}.
         *
         * @return canonical type name
         */
        public static java.lang.String _getCanonicalTypeName() {
            return _getClassType().getName();
        }

        private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
            return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
         *
         * Returns new instance of this binding class and injects the provided data value.<br>
         *
         * <b>WARNING:</b> The returned object is not fully initialized.<br>
         *
         * @param structValue the source of the data contained in the binding object. Could
         *                    contain more data than fields of this class can describe i.e.
         *                    newer version of the binding object. Could be null.
         * @return the static bindings <code>StructType</code>
         */
        public static Info _newInstance(com.vmware.vapi.data.StructValue structValue) {
            return new Info(structValue);
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
         * Serves as a versioning mechanism.
         */
        public static Info _newInstance2(com.vmware.vapi.data.StructValue structValue) {
            return new Info(structValue);
        }

        /**
         * Builder class for {@link Info}.
         */
        public static final class Builder {
            private java.lang.String id;
            private java.lang.String checksum;

            /**
             * Constructor with parameters for the required properties of
             * {@link Info}.
             */
            public Builder(java.lang.String id, java.lang.String checksum) {
                this.id = id;
                this.checksum = checksum;
            }

            public Info build() {
                Info result = new Info();
                result.setId(this.id);
                result.setChecksum(this.checksum);
                return result;
            }
        }


        static com.vmware.vapi.bindings.type.StructType __initStructType() {
            com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
            java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
            java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
            java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
            fields.put("id", new com.vmware.vapi.bindings.type.IdType("com.vmware.vapi.provider"));
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                    "id",
                                                                                    "getId",
                                                                                    "setId");
            fieldNameDetails.put(details.getCanonicalName(), details);
            fields.put("checksum", new com.vmware.vapi.bindings.type.StringType());
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("checksum",
                                                                                    "checksum",
                                                                                    "getChecksum",
                                                                                    "setChecksum");
            fieldNameDetails.put(details.getCanonicalName(), details);
            return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.introspection.provider.info",
                                                                fields,
                                                                com.vmware.vapi.std.introspection.ProviderTypes.Info.class,
                                                                validators,
                                                                false,
                                                                null,
                                                                fieldNameDetails,
                                                                null,
                                                                null);
        }
    }

}
