/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 * Contains only data type definitions and no methods.
 * Shared by client-side stubs and server-side skeletons to ensure type
 * compatibility.
 */

package com.vmware.vapi.std.introspection;

/**
 * Defines the data types of the {@link Service}
 * API service.
 */
/**
 * The {@link com.vmware.vapi.std.introspection.Service} service provides
 * operations to retrieve information about the services exposed by a vAPI
 * provider. A provider is a container that exposes one or more vAPI services.
 */
public interface ServiceTypes {
    /**
     * Identifier of the service
     */
    public static final String _VAPI_SERVICE_ID = "com.vmware.vapi.std.introspection.service";

    /**
     * Information about a vAPI service
     */
    public static final class Info implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

        private static final long serialVersionUID = 1L;

        private java.util.Set<java.lang.String> operations;

        protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

        /**
         * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
         */
        public Info(java.util.Set<java.lang.String> operations) {
            this();
            this.operations = operations;
        }

        /**
         * Default constructor.
         */
        public Info() {
        }

        protected Info(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
            this.__dynamicStructureFields = __dynamicStructureFields;
        }


        /**
         * Set of identifiers of operations present in the service
         *
         * @return The current value of the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain identifiers for the resource type: {@code com.vmware.vapi.operation}.
         * When methods return a value of this class as a return value, the property will
         * contain identifiers for the resource type: {@code com.vmware.vapi.operation}.
         */
        public java.util.Set<java.lang.String> getOperations() {
            return this.operations;
        }

        /**
         * Set of identifiers of operations present in the service
         *
         * @param operations New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain identifiers for the resource type: {@code com.vmware.vapi.operation}.
         * When methods return a value of this class as a return value, the property will
         * contain identifiers for the resource type: {@code com.vmware.vapi.operation}.
         */
        public void setOperations(java.util.Set<java.lang.String> operations) {
            this.operations = operations;
        }

       @java.lang.Override
        public com.vmware.vapi.bindings.type.StructType _getType() {
            return com.vmware.vapi.std.introspection.ServiceDefinitions.info;
        }

        @java.lang.Override
        public com.vmware.vapi.data.StructValue _getDataValue() {
            com.vmware.vapi.data.StructValue dataValue;
            if (__dynamicStructureFields != null) {
                dataValue = __dynamicStructureFields.copy();
            } else {
                dataValue = createEmptyStructValue();
            }
            this._updateDataValue(dataValue);
            return dataValue;
        }

        protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
            structValue.setField("operations",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.operations, this._getType().getField("operations")));
        }

        @java.lang.Override
        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        @java.lang.Override
        public boolean equals(java.lang.Object obj) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
        }

        @java.lang.Override
        public int hashCode() {
            return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
        }

        @java.lang.Override
        public java.lang.String toString() {
            return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
        }

        @java.lang.Override
        public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
        }

        @java.lang.Override
        public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
        }

        @java.lang.Override
        public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
            if (_getType().getFieldNames().contains(fieldName)) {
                 throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
            }
            if(__dynamicStructureFields == null) {
                __dynamicStructureFields = createEmptyStructValue();
            }
            __dynamicStructureFields.setField(fieldName, fieldValue);
        }

        @java.lang.Override
        public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
            if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
                throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
            }
            return __dynamicStructureFields.getField(fieldName);
        }

        @java.lang.Override
        public java.util.Set<java.lang.String> _getDynamicFieldNames() {
            if (__dynamicStructureFields == null) {
                return java.util.Collections.<java.lang.String>emptySet();
            }
            return __dynamicStructureFields.getFieldNames();
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.
         *
         * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
         * type for this <code>Structure</code>.
         */
        public static com.vmware.vapi.bindings.type.StructType _getClassType() {
            return com.vmware.vapi.std.introspection.ServiceDefinitions.info;
        }

        @java.lang.Override
        public java.lang.String _getCanonicalName() {
            if (__dynamicStructureFields != null) {
                return __dynamicStructureFields.getName();
            }
            return com.vmware.vapi.std.introspection.ServiceDefinitions.info.getName();
        }

        /**
         * Returns the canonical type name. See {@link #_getCanonicalName()}.
         *
         * @return canonical type name
         */
        public static java.lang.String _getCanonicalTypeName() {
            return _getClassType().getName();
        }

        private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
            return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
         *
         * Returns new instance of this binding class and injects the provided data value.<br>
         *
         * <b>WARNING:</b> The returned object is not fully initialized.<br>
         *
         * @param structValue the source of the data contained in the binding object. Could
         *                    contain more data than fields of this class can describe i.e.
         *                    newer version of the binding object. Could be null.
         * @return the static bindings <code>StructType</code>
         */
        public static Info _newInstance(com.vmware.vapi.data.StructValue structValue) {
            return new Info(structValue);
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
         * Serves as a versioning mechanism.
         */
        public static Info _newInstance2(com.vmware.vapi.data.StructValue structValue) {
            return new Info(structValue);
        }

        /**
         * Builder class for {@link Info}.
         */
        public static final class Builder {
            private java.util.Set<java.lang.String> operations;

            /**
             * Constructor with parameters for the required properties of
             * {@link Info}.
             */
            public Builder(java.util.Set<java.lang.String> operations) {
                this.operations = operations;
            }

            public Info build() {
                Info result = new Info();
                result.setOperations(this.operations);
                return result;
            }
        }


        static com.vmware.vapi.bindings.type.StructType __initStructType() {
            com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
            java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
            java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
            java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
            fields.put("operations", new com.vmware.vapi.bindings.type.SetType(new com.vmware.vapi.bindings.type.IdType("com.vmware.vapi.operation")));
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("operations",
                                                                                    "operations",
                                                                                    "getOperations",
                                                                                    "setOperations");
            fieldNameDetails.put(details.getCanonicalName(), details);
            return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.introspection.service.info",
                                                                fields,
                                                                com.vmware.vapi.std.introspection.ServiceTypes.Info.class,
                                                                validators,
                                                                false,
                                                                null,
                                                                fieldNameDetails,
                                                                null,
                                                                null);
        }
    }

}
