/* **********************************************************
 * Copyright (c) 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.tracing;

/**
 * Defines the granularity of the tracing tags and messages that will be logged
 * in the span created by the vapi stack
 */
public enum TracingLevel {

      /**
       * Adds tracing tags only. Does not log any tracing
       * messages.
       */
      INFO,

      /**
       * Adds tracing messages describing certain phases in
       * the processing of the vAPI call.
       */
      DEBUG,

      /**
       * In addition to the tracing messages, errors are
       * logged more verbosely. For example, when possible
       * the stack trace of an exception will be included as
       * a log message in the span.
       */
      TRACE
}
