/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubCreator;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.internal.ClassLoaderUtil;
import com.vmware.vapi.internal.bindings.Stub;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.util.Validate;
import java.lang.reflect.Constructor;

public final class StubFactory
implements StubCreator {
    private static final String STUB_SUFFIX = "Stub";
    private final ApiProvider apiProvider;
    private final TypeConverter typeConverter;

    public StubFactory(ApiProvider apiProvider) {
        this(apiProvider, null);
    }

    public StubFactory(ApiProvider apiProvider, TypeConverter typeConverter) {
        Validate.notNull(apiProvider);
        this.apiProvider = apiProvider;
        this.typeConverter = typeConverter;
    }

    @Override
    public <T extends Service> T createStub(Class<T> vapiIface) {
        return this.createStub(vapiIface, null);
    }

    @Override
    public <T extends Service> T createStub(Class<T> vapiIface, StubConfigurationBase config) {
        if (vapiIface == null) {
            throw new IllegalArgumentException("vapiIface is required");
        }
        if (!vapiIface.isInterface()) {
            throw new IllegalArgumentException("vapiIface must represent Java interface");
        }
        if (config == null) {
            config = new StubConfiguration();
        }
        String implClassName = StubFactory.resolveStubClassName(vapiIface);
        try {
            ClassLoader cl = ClassLoaderUtil.getServiceClassLoader();
            Class<?> implClass = cl.loadClass(implClassName);
            if (!vapiIface.isAssignableFrom(implClass)) {
                throw new RuntimeException("Found stub implementation class which doesn't implement requested interface: " + vapiIface.getName());
            }
            if (!Stub.class.isAssignableFrom(implClass)) {
                throw new RuntimeException("Found stub implementation class which doesn't extend " + Stub.class.getName());
            }
            return (T)((Service)vapiIface.cast(this.instantiateStubClass(config, implClass)));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object instantiateStubClass(StubConfigurationBase config, Class<?> implClass) throws Exception {
        if (this.typeConverter == null) {
            Constructor<?> ctor = implClass.getConstructor(ApiProvider.class, StubConfigurationBase.class);
            ctor.setAccessible(true);
            return ctor.newInstance(this.apiProvider, config);
        }
        Constructor<?> ctor = implClass.getConstructor(ApiProvider.class, TypeConverter.class, StubConfigurationBase.class);
        ctor.setAccessible(true);
        return ctor.newInstance(this.apiProvider, this.typeConverter, config);
    }

    private static String resolveStubClassName(Class<?> vapiIface) {
        return vapiIface.getName() + STUB_SUFFIX;
    }
}

