/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings.client;

import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.std.Progress;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncCallbackSyncAdapter<T>
extends AsyncCallback<T> {
    private final Lock lock = new ReentrantLock();
    private final Condition set = this.lock.newCondition();
    private boolean completed = false;
    private T result;
    private RuntimeException error;

    public T get() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.completed) {
                this.set.await();
            }
            if (this.error == null) {
                T t = this.result;
                return t;
            }
            throw this.error;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onProgress(Progress progress) {
    }

    @Override
    public void onResult(T result) {
        this.lock.lock();
        try {
            this.result = result;
            this.completed = true;
            this.set.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onError(RuntimeException error) {
        this.lock.lock();
        try {
            this.error = error;
            this.completed = true;
            this.set.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

