/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import com.vmware.vapi.internal.bindings.convert.impl.GregorianCalendarConverter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;

public class ZonedDateTimeTimeConverter
implements PrimitiveConverter<StringValue> {
    private GregorianCalendarConverter calendarConverter;

    public ZonedDateTimeTimeConverter(GregorianCalendarConverter calendarConverter) {
        this.calendarConverter = calendarConverter;
    }

    public ZonedDateTime fromValue(StringValue value) {
        GregorianCalendar calendar = this.calendarConverter.fromValue(value);
        return calendar.toZonedDateTime();
    }

    @Override
    public StringValue toValue(Object primitiveBinding) {
        ZonedDateTime zonedDateTime = ConvertUtil.narrowType(primitiveBinding, ZonedDateTime.class);
        ZonedDateTime timeZ = zonedDateTime.withZoneSameInstant(ZoneId.of("Z"));
        return (StringValue)this.calendarConverter.toValue(GregorianCalendar.from(timeZ));
    }
}

