/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.UnresolvedError;
import com.vmware.vapi.bindings.type.AnyErrorType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import com.vmware.vapi.internal.util.Validate;

public final class StaticErrorAnyErrorConverter
implements UniTypeConverter<ErrorValue, AnyErrorType> {
    private final NameToTypeResolver resolver;

    public StaticErrorAnyErrorConverter(NameToTypeResolver resolver) {
        Validate.notNull(resolver);
        this.resolver = resolver;
    }

    @Override
    public Object fromValue(ErrorValue value, AnyErrorType declaredType, TypeConverter typeConverter) {
        Type type = this.resolver.resolve(value.getName());
        if (type != null) {
            return typeConverter.convertToJava(value, type);
        }
        return new UnresolvedError(value);
    }

    @Override
    public DataValue toValue(Object binding, AnyErrorType declaredType, TypeConverter typeConverter, TypeConverter.ConversionContext cc) {
        if (binding instanceof StaticStructure) {
            StaticStructure struct = (StaticStructure)binding;
            StructType type = struct._getType();
            return typeConverter.convertToVapi(binding, type, cc);
        }
        UnresolvedError error = ConvertUtil.narrowType(binding, UnresolvedError.class);
        return error._getDataValue();
    }
}

