/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest.authn;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vapi.internal.protocol.client.rest.authn.FetchTokenException;
import com.vmware.vapi.internal.protocol.client.rest.authn.HttpTokenProviderBase;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CspTokenProvider
extends HttpTokenProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(CspTokenProvider.class);

    public CspTokenProvider(String url, HttpConfiguration httpConfig) {
        super(url, httpConfig);
    }

    @Override
    protected HttpUriRequest buildTokenRequest(String username, String password) throws JsonProcessingException {
        logger.debug("Getting CSP authentication token using username and password.");
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("username", username);
        requestBody.put("password", password);
        return this.buildRequest(requestBody);
    }

    @Override
    protected HttpUriRequest buildTokenRequest(String accessKey) throws JsonProcessingException {
        logger.debug("Getting CSP authentication token using access-key.");
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("key", accessKey);
        return this.buildRequest(requestBody);
    }

    @Override
    protected String extractToken(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new FetchTokenException("Failed to obtain token. Received HTTP status code: " + response.getStatusLine().getStatusCode());
        }
        Throwable throwable = null;
        try (InputStream inStream = response.getEntity().getContent();){
            ObjectMapper jsonMapper = new ObjectMapper();
            Map result = (Map)jsonMapper.readValue(inStream, (TypeReference)new TypeReference<Map<String, String>>(){});
            if (result.containsKey("cspAuthToken")) {
                String string = (String)result.get("cspAuthToken");
                return string;
            }
            try {
                throw new FetchTokenException("Failed to obtain token. No 'cspAuthToken' property found in response.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private HttpPost buildRequest(Map<String, String> requestBody) throws JsonProcessingException {
        HttpPost request = new HttpPost(this.getUrl());
        ObjectMapper jsonMapper = new ObjectMapper();
        String requestBodyString = jsonMapper.writeValueAsString(requestBody);
        request.setEntity((HttpEntity)new StringEntity(requestBodyString, ContentType.APPLICATION_JSON));
        return request;
    }
}

