/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.protocol.common.http.HttpConstants;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheClientHeadersProvider
implements HttpRequestInterceptor {
    private static Logger logger = LoggerFactory.getLogger(ApacheClientHeadersProvider.class);
    private HttpConfiguration.HeadersProvider headersProvider;

    public ApacheClientHeadersProvider(HttpConfiguration.HeadersProvider headersProvider) {
        this.headersProvider = headersProvider;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Iterable<HttpConfiguration.Header> headers = this.headersProvider.getHeaders();
        if (headers == null) {
            return;
        }
        for (HttpConfiguration.Header header : headers) {
            String name = header.getName();
            if (HttpConstants.RESERVED_HEADERS.contains(name)) {
                logger.debug("HTTP {0} custom header won't be sent over the wire. It is being used by the vAPI client.", (Object)header);
                continue;
            }
            request.addHeader(name, header.getValue());
        }
    }
}

