/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientRequestConfigurationMerger;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheNioHttpClientBuilder;
import com.vmware.vapi.internal.protocol.client.rpc.http.ConnectionMonitor;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.NioMainResponseConsumer;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import com.vmware.vapi.internal.tracing.TracingSpan;
import com.vmware.vapi.internal.tracing.otel.TracingAttributeKey;
import com.vmware.vapi.internal.util.TracingUtil;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttpAsyncClientTransport
implements CorrelatingClient {
    private static Logger logger = LoggerFactory.getLogger(ApacheHttpAsyncClientTransport.class);
    private final String uri;
    private final CloseableHttpAsyncClient httpClient;
    private final ApacheClientRequestConfigurationMerger configMerger;
    private final HttpConfiguration.Protocol protocol;
    private final int maxResponseSize;
    private ConnectionMonitor.CleanableConnectionPool pool;

    public ApacheHttpAsyncClientTransport(String uri) {
        this(uri, new HttpConfiguration.Builder().getConfig());
    }

    public ApacheHttpAsyncClientTransport(String uri, HttpConfiguration httpConfig) {
        this(uri, httpConfig, new ApacheNioHttpClientBuilder());
    }

    private ApacheHttpAsyncClientTransport(String uri, HttpConfiguration httpConfig, ApacheNioHttpClientBuilder builder) {
        this(uri, builder.buildAndConfigure(httpConfig), ApacheHttpUtil.createDefaultRequestConfig(httpConfig), httpConfig.getProtocol(), httpConfig.getMaxResponseSize());
        this.pool = builder.registerClientWithConnectionMonitor();
    }

    public static CloseableHttpAsyncClient createDefaultHttpClient(HttpConfiguration httpConfig) {
        ApacheNioHttpClientBuilder builder = new ApacheNioHttpClientBuilder();
        return builder.buildAndConfigure(httpConfig);
    }

    public ApacheHttpAsyncClientTransport(String uri, CloseableHttpAsyncClient httpClient, HttpConfiguration.Protocol protocol) {
        this(uri, httpClient, null, protocol);
    }

    public ApacheHttpAsyncClientTransport(String uri, CloseableHttpAsyncClient httpClient, RequestConfig defaultConfiguration, HttpConfiguration.Protocol protocol) {
        this(uri, httpClient, defaultConfiguration, protocol, Integer.MAX_VALUE);
    }

    public ApacheHttpAsyncClientTransport(String uri, CloseableHttpAsyncClient httpClient, RequestConfig defaultConfiguration, HttpConfiguration.Protocol protocol, int maxResponseSize) {
        Validate.notNull(uri);
        Validate.notNull(httpClient);
        Validate.isTrue(maxResponseSize > 0);
        this.uri = uri;
        this.protocol = protocol;
        this.httpClient = httpClient;
        this.configMerger = new ApacheClientRequestConfigurationMerger(defaultConfiguration);
        this.maxResponseSize = maxResponseSize;
    }

    @Override
    public void send(CorrelatingClient.SendParams params) {
        HttpPost post = new HttpPost(this.uri);
        post.setEntity((HttpEntity)new InputStreamEntity(params.getRequest(), (long)params.getRequestLength()));
        Util.addHeaders(post, params.getContentType(), params.getAcceptedTypes(), this.protocol, params.getServiceId(), params.getOperationId(), params.getExecutionContext());
        if (Util.checkRequestAborted(params.getAbortHandle(), params.getCbFactory())) {
            return;
        }
        Util.registerAbortListerner(params.getCbFactory(), post, params.getAbortHandle());
        TracingSpan tracingSpan = params.getTracingSpan();
        TracingUtil.registerRequestDataIntoSpan(tracingSpan, (HttpUriRequest)post, this.protocol, TracingAttributeKey.IoType.NIO);
        tracingSpan.injectInto(post, TracingUtil::addHeader);
        logger.debug("Executing async request.");
        HttpClientContext httpCtx = ApacheHttpUtil.createHttpContext(params.getExecutionContext(), this.configMerger);
        this.httpClient.execute(HttpAsyncMethods.create((HttpUriRequest)post), (HttpAsyncResponseConsumer)new NioMainResponseConsumer(params.getCbFactory(), params.getExecutionContext(), (HttpContext)httpCtx, params.getAcceptedTypes(), params.getAbortHandle(), tracingSpan, this.maxResponseSize), (HttpContext)httpCtx, (FutureCallback)new FutureCallbackImpl(this.uri, params.getAbortHandle(), params.getCbFactory()));
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
            this.pool = null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class FutureCallbackImpl
    implements FutureCallback<HttpResponse> {
        private final CorrelatingClient.ResponseCallbackFactory cbFactory;
        private final AbortHandle abortHandle;
        private final String uri;

        public FutureCallbackImpl(String uri, AbortHandle abortHandle, CorrelatingClient.ResponseCallbackFactory cbFactory) {
            this.uri = uri;
            this.cbFactory = cbFactory;
            this.abortHandle = abortHandle;
        }

        public void completed(HttpResponse result) {
        }

        public void failed(Exception ex) {
            logger.debug("HTTP exchange failed", (Throwable)ex);
            if (this.cbFactory == null) {
                logger.debug("CbFactory is null - fail will not be propagated");
            }
            this.cbFactory.failed(ApacheHttpClientExceptionTranslator.translate(ex, this.abortHandle, this.uri));
        }

        public void cancelled() {
            logger.debug("HTTP exchange cancelled");
            if (this.cbFactory == null) {
                logger.debug("CbFactory is null - fail will not be propagated");
            }
            this.cbFactory.failed(ApacheHttpClientExceptionTranslator.translate(new CancellationException(), this.abortHandle));
        }
    }
}

