/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientRequestConfigurationMerger;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.ConnectionMonitor;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.BioResponseContentHandler;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import com.vmware.vapi.internal.tracing.TracingSpan;
import com.vmware.vapi.internal.tracing.otel.TracingAttributeKey;
import com.vmware.vapi.internal.util.TracingUtil;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClient
implements CorrelatingClient {
    private static Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private final String uri;
    private final CloseableHttpClient httpClient;
    private final ApacheClientRequestConfigurationMerger configMerger;
    private final HttpConfiguration.Protocol protocol;
    private ConnectionMonitor.CleanableConnectionPool pool;

    public HttpClient(String uri) {
        this(uri, new HttpConfiguration.Builder().getConfig());
    }

    public HttpClient(String uri, HttpConfiguration httpConfig) {
        Validate.notNull(uri);
        Validate.notNull(httpConfig);
        this.uri = uri;
        this.protocol = httpConfig.getProtocol();
        this.httpClient = this.createDefaultHttpClient(httpConfig);
        RequestConfig defaultConfig = ApacheHttpUtil.createDefaultRequestConfig(httpConfig);
        this.configMerger = new ApacheClientRequestConfigurationMerger(defaultConfig);
    }

    public HttpClient(String uri, CloseableHttpClient httpClient) {
        Validate.notNull(uri);
        Validate.notNull(httpClient);
        this.uri = uri;
        this.httpClient = httpClient;
        this.protocol = HttpConfiguration.Protocol.VAPI_JSON_RPC_1_0;
        this.configMerger = new ApacheClientRequestConfigurationMerger(null);
    }

    private CloseableHttpClient createDefaultHttpClient(HttpConfiguration httpConfig) {
        assert (httpConfig != null);
        try {
            new URL(this.uri);
        }
        catch (MalformedURLException ex) {
            logger.error("Exception while trying to parse URL", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        ApacheBioHttpClientBuilder httpClientBuilder = new ApacheBioHttpClientBuilder();
        CloseableHttpClient result = httpClientBuilder.buildAndConfigure(httpConfig);
        this.pool = httpClientBuilder.registerClientWithConnectionMonitor();
        return result;
    }

    private HttpResponse invoke(CorrelatingClient.SendParams params) throws IOException {
        HttpPost post = new HttpPost(this.uri);
        post.setEntity((HttpEntity)new InputStreamEntity(params.getRequest(), (long)params.getRequestLength()));
        Util.addHeaders(post, params.getContentType(), params.getAcceptedTypes(), this.protocol, params.getServiceId(), params.getOperationId(), params.getExecutionContext());
        logger.debug("Value of uri is:" + this.uri);
        if (Util.checkRequestAborted(params.getAbortHandle(), params.getCbFactory())) {
            return null;
        }
        Util.registerAbortListerner(params.getCbFactory(), post, params.getAbortHandle());
        HttpClientContext context = ApacheHttpUtil.createHttpContext(params.getExecutionContext(), this.configMerger);
        TracingSpan tracingSpan = params.getTracingSpan();
        TracingUtil.registerRequestDataIntoSpan(tracingSpan, (HttpUriRequest)post, this.protocol, TracingAttributeKey.IoType.BIO);
        tracingSpan.injectInto(post, TracingUtil::addHeader);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post, (HttpContext)context);
        TracingUtil.registerResponseIntoSpan(tracingSpan, (HttpResponse)response, (HttpContext)context);
        ApacheHttpUtil.validateHttpResponse((HttpResponse)response, params.getAcceptedTypes());
        return response;
    }

    @Override
    public void send(CorrelatingClient.SendParams params) {
        if (Util.checkRequestAborted(params.getAbortHandle(), params.getCbFactory())) {
            return;
        }
        CorrelatingClient.ResponseCallbackFactory cbFactory = params.getCbFactory();
        try {
            HttpResponse httpResponse = this.invoke(params);
            HttpEntity responseBody = httpResponse.getEntity();
            if (responseBody == null) {
                return;
            }
            String contentType = null;
            if (responseBody.getContentType() != null) {
                contentType = responseBody.getContentType().getValue();
            }
            CorrelatingClient.ResponseCallbackParams cbParams = new CorrelatingClient.ResponseCallbackParams(contentType);
            CorrelatingClient.ResponseCallback cb = cbFactory.createResponseCallback(cbParams);
            InputStream inp = responseBody.getContent();
            this.handleContent(contentType, inp, cb, params.getAbortHandle(), this.uri);
        }
        catch (Exception ex) {
            cbFactory.failed(ApacheHttpClientExceptionTranslator.translate(ex, params.getAbortHandle(), this.uri));
        }
    }

    private void handleContent(String contentType, InputStream content, CorrelatingClient.ResponseCallback cb, AbortHandle abortHandle, String uri) throws IOException {
        BioResponseContentHandler contentHandler = new BioResponseContentHandler(contentType, cb);
        contentHandler.handleResposne(content, abortHandle, uri);
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
            this.pool = null;
        }
        catch (IOException e) {
            logger.warn("Exception while trying to close the HttpClient", (Throwable)e);
        }
    }
}

