/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.http;

import com.vmware.vapi.internal.util.StringUtils;
import com.vmware.vapi.internal.util.Validate;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlUtil.class);
    private static final String URI_PATH_SEPARATOR = "/";
    private static final Pattern pattern = Pattern.compile("\\{(.+?)\\}");
    private final URLCodec urlCodec = new URLCodec();

    public String replacePathVariables(String template, Map<String, String> vars) {
        LOGGER.trace("Replace path variables called: template={}, vars={}", (Object)template, vars);
        Matcher matcher = pattern.matcher(template);
        StringBuilder builder = new StringBuilder();
        int parseIx = 0;
        while (matcher.find()) {
            String key = matcher.group().substring(1, matcher.group().length() - 1);
            String val = vars.get(key);
            LOGGER.trace("Found template key: {}", (Object)key);
            if (val == null) {
                LOGGER.trace("No value specified for key '{}', skipping replace.", (Object)key);
                continue;
            }
            LOGGER.trace("Replacing key '{}' with value '{}'", (Object)key, (Object)val);
            builder.append(template.substring(parseIx, matcher.start()));
            builder.append(val);
            parseIx = matcher.end();
        }
        if (parseIx < template.length() - 1) {
            builder.append(template.substring(parseIx));
        }
        return builder.toString();
    }

    public String joinUrls(String baseUrl, String ... paths) {
        if (baseUrl == null) {
            baseUrl = "";
        }
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.strip(baseUrl, URI_PATH_SEPARATOR));
        for (String path : paths) {
            result.append(URI_PATH_SEPARATOR);
            result.append(StringUtils.strip(path, URI_PATH_SEPARATOR));
        }
        return result.toString();
    }

    public String encodeUrlPath(String path) {
        try {
            return this.urlCodec.encode(path);
        }
        catch (EncoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String encodeQuery(Map<String, String> params) {
        StringBuilder resultBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = params.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> param = iter.next();
            String key = param.getKey();
            String value = param.getValue();
            Validate.notNull(key);
            resultBuilder.append(this.encodeUrlPath(key));
            if (value != null) {
                resultBuilder.append("=").append(this.encodeUrlPath(value));
            }
            if (!iter.hasNext()) continue;
            resultBuilder.append("&");
        }
        return resultBuilder.toString();
    }
}

