/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.common.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.common.DataValueBuilder;
import com.vmware.vapi.internal.protocol.common.DirectDeserializer;
import com.vmware.vapi.internal.protocol.common.DirectSerializer;
import com.vmware.vapi.internal.protocol.common.SerializerConfig;
import com.vmware.vapi.internal.protocol.common.json.JsonDirectDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonDirectSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class JsonConverter {
    private final DirectSerializer directSerializer;
    private final DirectDeserializer directDeserializer;
    private final SerializerConfig serializerConfig;

    public JsonConverter() {
        JsonFactory factory = new JsonFactory();
        this.directSerializer = new JsonDirectSerializer(factory);
        this.directDeserializer = new JsonDirectDeserializer(factory);
        this.serializerConfig = new SerializerConfig(false);
    }

    public DataValue toDataValue(String json) {
        byte[] buf = json.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        return this.toDataValue(input);
    }

    public DataValue toDataValue(InputStream input) {
        DataValueBuilder builder = new DataValueBuilder();
        try {
            this.directDeserializer.deserialize(builder, input);
        }
        catch (IOException e) {
            throw JsonConverter.toVapiCoreException(e, "vapi.json.deserialize.ioerror");
        }
        return builder.getResult();
    }

    public String fromDataValue(DataValue value) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.fromDataValue(value, outputStream);
        return new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
    }

    public void fromDataValue(DataValue value, OutputStream outputStream) {
        try {
            this.directSerializer.serialize(value, outputStream, this.serializerConfig);
        }
        catch (IOException e) {
            throw JsonConverter.toVapiCoreException(e, "vapi.json.serialize.ioerror");
        }
    }

    private static CoreException toVapiCoreException(Exception ex, String id) {
        return new CoreException(MessageFactory.getMessage(id, ex.getMessage()), (Throwable)ex);
    }
}

