/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.ObjectRegistry;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.generators.joap.DummyRawObject;
import emitters.generators.joap.MoTypesList;
import emitters.lists.CoreObjects;
import emitters.model.DataObject;
import emitters.model.DataProperty;
import emitters.model.Entity;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class JoapEmitter
extends VmodlEmitter {
    private static final String AT_LINK = "{@link ";
    private static final String AT_LINK_TERMINATORS = " #}\n";
    private static final String AT_SEE = "@see ";
    private static final String AT_SEE_TERMINATORS = " #)\n";
    protected final String _folderPrefix;
    protected static Version _targetVersion;
    protected final MoTypesList _moTypesList;
    protected final DataObject _Any;
    protected final DataObject _MoRef;
    protected final List<DataObject> _methodParams;
    protected static final String CORE_NAMESPACE = "core";
    protected static final String CORE_PACKAGE = "core.";
    protected static final String ANY_SCHEMA_NAME = "Any";
    protected static final String MOREF_SCHEMA_NAME = "MoRef";
    protected static final String MOID_PARAM_NAME = "moId";
    protected static final String MOID_PARAM_SCHEMA_NAME = "moId";
    protected static final String DISCRIMINATOR = "className";
    protected static final String ARRAY_SUFFIX = ".array";
    protected static final String ENUM_SUFFIX = ".enum";
    protected static final String PARAMS_SUFFIX = ".params";
    protected static final String ARRAY;
    protected static final String ENUM;
    protected static final String PARAMS;
    protected static final CoreObjects CORE_OBJECTS;
    protected static final Primitive[] PRIMITIVES;
    private static final String VMODL_QUERY_PREFIX = "vmodl.query.";
    private static final String QUERY_PREFIX = "query.";
    private static final String VMODL_PREFIX = "vmodl.";
    private static final String IN_ANY_PLACEHOLDER = ". To be used in {@link Any} placeholders";

    protected JoapEmitter(String folder) {
        this(folder, false);
    }

    protected JoapEmitter(String folder, boolean isVmodl2) {
        this._folderPrefix = folder + File.separator;
        _targetVersion = Versions.getTargetVersion();
        this._Any = JoapEmitter.createAnyType();
        Enum moTypesEnum = MoTypesList.createEnum();
        this._moTypesList = new MoTypesList(moTypesEnum);
        this._MoRef = JoapEmitter.createMoRef(isVmodl2 ? null : moTypesEnum);
        JoapEmitter.setDefaultBase(this._Any);
        this._methodParams = new ArrayList<DataObject>(128);
    }

    private static DataObject createAnyType() {
        DummyRawObject rawAny = new DummyRawObject(ANY_SCHEMA_NAME, "", "The base of all data types. Not to be used directly on the wire.");
        DataObject Any2 = new DataObject(rawAny, null);
        Any2.setVersion(Version._root);
        VmodlDecl stringDecl = new VmodlDecl(VmodlDecl.TypeId.STRING);
        JoapEmitter.addDataProperty(Any2, DISCRIMINATOR, stringDecl);
        return Any2;
    }

    private static DataObject createMoRef(Enum moTypes) {
        DummyRawObject rawMoRef = new DummyRawObject(MOREF_SCHEMA_NAME, "", "A reference to a managed object on the server.");
        DataObject moRef = new DataObject(rawMoRef, null);
        moRef.setVersion(Version._root);
        VmodlDecl stringDecl = new VmodlDecl(VmodlDecl.TypeId.STRING);
        VmodlDecl moTypesDecl = moTypes != null ? new VmodlDecl(VmodlDecl.TypeId.ENUM, moTypes) : stringDecl;
        JoapEmitter.addDataProperty(moRef, "type", moTypesDecl);
        JoapEmitter.addDataProperty(moRef, "moId", stringDecl);
        return moRef;
    }

    private static void setDefaultBase(DataObject defaultBase) {
        for (VmodlObject object : ObjectRegistry.getAllObjects()) {
            DataObject dataObject;
            if (object.getKind() != VmodlObject.Kind.DataObject || (dataObject = (DataObject)object).getBaseObject() != null) continue;
            dataObject.setBaseObject(defaultBase);
        }
    }

    private DataObject createParamsType(ManagedObject managedObject, Method method) {
        String jsonName = JoapEmitter.getJsonName(managedObject) + "." + method.getName();
        String comment = "The parameters of {@link " + managedObject.getQualifiedVmodlType() + "#" + method.getName() + "}";
        DataObject paramsType = this.createHelperType(jsonName, PARAMS, PARAMS_SUFFIX, comment);
        for (Parameter parameter : method.getParameterList()) {
            JoapEmitter.addDataProperty(paramsType, parameter.getName(), parameter.getDecl());
        }
        return paramsType;
    }

    private DataObject createHelperType(String jsonName, String suffix, String dottedSuffix, String comment) {
        int dotPos = jsonName.lastIndexOf(46);
        String packageName = jsonName.substring(0, dotPos);
        String typeName = jsonName.substring(dotPos + 1) + JoapEmitter.capitalize(suffix);
        DummyRawObject rawHelper = new DummyRawObject(typeName, packageName, comment);
        DataObject helperType = new DataObject(rawHelper, null);
        JoapEmitter.setJsonName(helperType, jsonName + dottedSuffix);
        return helperType;
    }

    protected BoxedPair createBoxedPrimitive(Primitive primitive) {
        String typeName = primitive.typeName;
        DummyRawObject rawObject = new DummyRawObject(typeName + "Value", CORE_NAMESPACE, "A boxed " + primitive.typeName + " primitive" + IN_ANY_PLACEHOLDER);
        DataObject boxedPrimitive = new DataObject(rawObject, null);
        JoapEmitter.setJsonName(boxedPrimitive, CORE_PACKAGE + typeName);
        VmodlDecl primitiveDecl = new VmodlDecl(primitive.typeId);
        this.initBoxedType(boxedPrimitive, primitiveDecl);
        DataObject boxedPrimitiveArray = this.createBoxedArray(primitive.typeId, null, JoapEmitter.getJsonName(boxedPrimitive));
        return new BoxedPair(boxedPrimitive, boxedPrimitiveArray);
    }

    protected BoxedPair createBoxedEnum(Enum enum_) {
        String enumName = JoapEmitter.getJsonName(enum_);
        String jsonName = enumName.substring(0, enumName.length() - ENUM_SUFFIX.length());
        String comment = "A boxed {@link " + enum_.getQualifiedVmodlType() + "} enum" + IN_ANY_PLACEHOLDER;
        DataObject boxedEnum = this.createHelperType(jsonName, "", "", comment);
        VmodlDecl enumDecl = new VmodlDecl(VmodlDecl.TypeId.ENUM, enum_);
        this.initBoxedType(boxedEnum, enumDecl);
        return new BoxedPair(boxedEnum, this.createBoxedArray(VmodlDecl.TypeId.ENUM, enum_, jsonName));
    }

    protected DataObject createBoxedArray(DataObject dataObject) {
        return this.createBoxedArray(VmodlDecl.TypeId.DATA, dataObject, JoapEmitter.getJsonName(dataObject));
    }

    private DataObject createBoxedArray(VmodlDecl.TypeId typeId, VmodlObject object, String jsonName) {
        String comment = object == null ? null : "A boxed array of {@link " + object.getQualifiedVmodlType() + "}" + IN_ANY_PLACEHOLDER;
        DataObject boxedArray = this.createHelperType(jsonName, ARRAY, ARRAY_SUFFIX, comment);
        VmodlDecl arrayDecl = new VmodlDecl(typeId, object);
        arrayDecl.setArray();
        this.initBoxedType(boxedArray, arrayDecl);
        return boxedArray;
    }

    private void initBoxedType(DataObject boxedType, VmodlDecl decl) {
        boxedType.setVersion(JoapEmitter.getVersion(decl));
        boxedType.setBaseObject(this._Any);
        JoapEmitter.addDataProperty(boxedType, "value", decl);
    }

    private static void addDataProperty(VmodlObject container, String name, VmodlDecl decl) {
        DataProperty dataProperty = new DataProperty(container, name, null, decl, false, null, JoapEmitter.getVersion(decl), null, -1);
        container.addProperty(dataProperty);
    }

    private static Version getVersion(VmodlDecl decl) {
        VmodlObject object = decl.getObject();
        return object != null ? object.getVersion() : Version._root;
    }

    public static String getJsonName(VmodlObject object) {
        String jsonName = object.getCustomName();
        return jsonName != null ? jsonName : JoapEmitter.setJsonName(object, JoapEmitter.evalJsonName(object));
    }

    private static String setJsonName(VmodlObject object, String jsonName) {
        object.setCustomName(jsonName);
        return jsonName;
    }

    private static String evalJsonName(VmodlObject object) {
        String fqdn = object.getQualifiedVmodlType();
        if (fqdn.startsWith(VMODL_QUERY_PREFIX)) {
            fqdn = QUERY_PREFIX + fqdn.substring(VMODL_QUERY_PREFIX.length());
        } else if (fqdn.startsWith(VMODL_PREFIX)) {
            fqdn = CORE_PACKAGE + fqdn.substring(VMODL_PREFIX.length());
        }
        if (object.getKind() == VmodlObject.Kind.Enum) {
            fqdn = fqdn + ENUM_SUFFIX;
        }
        return fqdn;
    }

    protected static boolean shouldEmit(VmodlApi vmodlApi) {
        return JoapEmitter.shouldEmit((Entity)vmodlApi) && !vmodlApi.isInternal();
    }

    protected static boolean shouldEmit(Entity versioned) {
        return JoapEmitter.shouldEmit(versioned.getVersion());
    }

    protected static boolean shouldEmit(Version version) {
        return _targetVersion.isAncestor(version);
    }

    protected DataObject registerMethodParams(ManagedObject managedObject, Method method) {
        List<Parameter> parameters = method.getParameterList();
        if (parameters.isEmpty()) {
            return null;
        }
        DataObject methodParams = this.createParamsType(managedObject, method);
        this._methodParams.add(methodParams);
        return methodParams;
    }

    protected String updateJavadocLinks(String comment, VmodlObject context) {
        if (comment == null) {
            return null;
        }
        comment = this.updateLinks(comment, context, AT_LINK, AT_LINK_TERMINATORS);
        return this.updateLinks(comment, context, AT_SEE, AT_SEE_TERMINATORS);
    }

    private String updateLinks(String comment, VmodlObject context, String prefix, String terminators) {
        int pos;
        StringBuilder result = new StringBuilder();
        int offset = 0;
        while ((pos = comment.indexOf(prefix, offset)) != -1) {
            int idStart = pos + prefix.length();
            while (comment.charAt(idStart) == ' ') {
                ++idStart;
            }
            result.append(comment.substring(offset, idStart));
            pos = idStart;
            while (terminators.indexOf(comment.charAt(pos)) == -1) {
                ++pos;
            }
            if (pos != idStart) {
                String vmodlName = comment.substring(idStart, pos);
                VmodlObject object = this.getObject(vmodlName, context);
                result.append(this.getLink(object));
            }
            offset = pos;
        }
        if (offset == 0) {
            return comment;
        }
        result.append(comment.substring(offset));
        return result.toString();
    }

    private VmodlObject getObject(String vmodlName, VmodlObject context) {
        if (ANY_SCHEMA_NAME.equals(vmodlName)) {
            return this._Any;
        }
        VmodlObject result = ObjectRegistry.getObject(vmodlName);
        if (result != null) {
            return result;
        }
        String path = context.getQualifiedVmodlType();
        while ((result = ObjectRegistry.getObject(path + "." + vmodlName)) == null) {
            int pos = path.lastIndexOf(".");
            if (pos == -1) {
                throw new RuntimeException("Unknown reference to " + vmodlName + " in " + context.getQualifiedVmodlType());
            }
            path = path.substring(0, pos);
        }
        return result;
    }

    protected abstract String getLink(VmodlObject var1);

    static {
        ARRAY = JoapEmitter.capitalize(ARRAY_SUFFIX.substring(1));
        ENUM = JoapEmitter.capitalize(ENUM_SUFFIX.substring(1));
        PARAMS = JoapEmitter.capitalize(PARAMS_SUFFIX.substring(1));
        CORE_OBJECTS = new CoreObjects();
        PRIMITIVES = new Primitive[]{new Primitive("Boolean", VmodlDecl.TypeId.BOOLEAN), new Primitive("Byte", VmodlDecl.TypeId.BYTE), new Primitive("Short", VmodlDecl.TypeId.SHORT), new Primitive("Int", VmodlDecl.TypeId.INT), new Primitive("Long", VmodlDecl.TypeId.LONG), new Primitive("Float", VmodlDecl.TypeId.FLOAT), new Primitive("Double", VmodlDecl.TypeId.DOUBLE), new Primitive("String", VmodlDecl.TypeId.STRING), new Primitive("DateTime", VmodlDecl.TypeId.DATETIME), new Primitive("URI", VmodlDecl.TypeId.URI), new Primitive("Binary", VmodlDecl.TypeId.BINARY), new Primitive("TypeName", VmodlDecl.TypeId.TYPENAME), new Primitive("PropPath", VmodlDecl.TypeId.PROPPATH), new Primitive("MethodName", VmodlDecl.TypeId.METHODNAME), new Primitive(MOREF_SCHEMA_NAME, VmodlDecl.TypeId.MANAGED)};
    }

    protected static class Primitive {
        String typeName;
        VmodlDecl.TypeId typeId;

        Primitive(String typeName_, VmodlDecl.TypeId typeId_) {
            this.typeName = typeName_;
            this.typeId = typeId_;
        }
    }

    protected class BoxedPair {
        final DataObject _boxedObject;
        final DataObject _boxedArray;

        BoxedPair(DataObject boxedObject, DataObject boxedArray) {
            this._boxedObject = boxedObject;
            this._boxedArray = boxedArray;
        }
    }
}

