/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import emitters.Services;
import emitters.Versions;
import emitters.core.SyntaxException;
import emitters.javac.Platform;
import emitters.model.Product;
import emitters.model.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import vmodl.breakingChangesList;
import vmodl.compatible;
import vmodl.displayName;
import vmodl.featureList;
import vmodl.metaVersion;
import vmodl.nsConfig;
import vmodl.nsDescription;
import vmodl.releaseList;
import vmodl.service;
import vmodl.supportsManagedObjectsOf;
import vmodl.versionDef;
import vmodl.versionId;
import vmodl.wsdlName;

public class VersionsLoader
extends emitters.backend.VersionsLoader {
    private Map<String, nsConfig> _nsConfigMap;

    @Override
    public Map<String, nsConfig> getNsConfigMap() {
        if (this._nsConfigMap == null) {
            this._nsConfigMap = new HashMap<String, nsConfig>();
            RoundEnvironment roundEnv = Platform.getRoundEnv();
            for (Element element : roundEnv.getElementsAnnotatedWith(nsConfig.class)) {
                PackageElement pkg = (PackageElement)element;
                String ns = pkg.getQualifiedName().toString();
                nsConfig nsConfig2 = pkg.getAnnotation(nsConfig.class);
                this._nsConfigMap.put(ns, nsConfig2);
            }
        }
        return this._nsConfigMap;
    }

    @Override
    public void loadNamespaces() {
        RoundEnvironment roundEnv = Platform.getRoundEnv();
        for (Element element : roundEnv.getElementsAnnotatedWith(nsDescription.class)) {
            PackageElement pkg = (PackageElement)element;
            String pkgName = pkg.getQualifiedName().toString();
            nsDescription ns = pkg.getAnnotation(nsDescription.class);
            service svc = pkg.getAnnotation(service.class);
            if (svc == null) {
                svc = Services.defaultService;
            }
            if (!ns.useLegacyVersions()) {
                String versionPrefix = pkgName + ".version.";
                for (versionDef def : ns.versions()) {
                    this.createNewGenerationVersion(versionPrefix + def.id(), svc, def);
                }
            }
            Product product = VersionsLoader.getProduct(ns);
            Versions.createNamespace(pkgName, ns, product);
            metaVersion mv = pkg.getAnnotation(metaVersion.class);
            if (mv == null) continue;
            breakingChangesList breakingChanges = pkg.getAnnotation(breakingChangesList.class);
            Versions.createMetaVersion(mv, pkgName, breakingChanges, svc, product);
        }
    }

    private Version.Kind sublimateVersionClass(versionDef.Kind kind) {
        switch (kind) {
            case FEATURE: {
                return Version.Kind.FEATURE;
            }
            case LTS: {
                return Version.Kind.LTS;
            }
        }
        throw new RuntimeException("Unknown version kind " + kind);
    }

    private void createOldStyleVersion(String versionName, service svc, TypeElement declaration) {
        wsdlName wireNs = declaration.getAnnotation(wsdlName.class);
        versionId versionId2 = declaration.getAnnotation(versionId.class);
        displayName displayName2 = declaration.getAnnotation(displayName.class);
        ArrayList<String> parents = new ArrayList<String>();
        compatible comp = declaration.getAnnotation(compatible.class);
        if (comp != null) {
            try {
                comp.value();
            }
            catch (MirroredTypesException mte) {
                for (TypeMirror typeMirror : mte.getTypeMirrors()) {
                    parents.add(typeMirror.toString());
                }
            }
        }
        supportsManagedObjectsOf supportedMO = declaration.getAnnotation(supportsManagedObjectsOf.class);
        Versions.createVersion(versionName, wireNs != null ? wireNs.value() : null, versionId2 != null ? versionId2.value() : null, displayName2 != null ? displayName2.value() : null, svc, parents, supportedMO, Version.Kind.LTS);
    }

    private void createNewGenerationVersion(String versionName, service svc, versionDef versionDef2) {
        String wireNs = versionDef2.wsdlName();
        String wireId = versionDef2.versionId();
        String displayName2 = versionDef2.displayName();
        ArrayList<String> parents = new ArrayList<String>();
        for (String parent : versionDef2.compatible()) {
            parents.add(parent);
        }
        supportsManagedObjectsOf supportedMO = versionDef2.supportedMO();
        if (supportedMO.value().length == 0) {
            supportedMO = null;
        }
        Versions.createVersion(versionName, this.nullIfEmpty(wireNs), this.nullIfEmpty(wireId), this.nullIfEmpty(displayName2), svc, parents, supportedMO, this.sublimateVersionClass(versionDef2.kind()));
    }

    private String nullIfEmpty(String s) {
        return s.isEmpty() ? null : s;
    }

    @Override
    public void loadClassBasedVersions() {
        for (TypeElement declaration : this.getVersionDeclarations()) {
            String versionName = declaration.getQualifiedName().toString();
            versionDef versionDef2 = declaration.getAnnotation(versionDef.class);
            service svc = this.findService(declaration);
            if (svc == null) {
                svc = Services.defaultService;
            }
            if (versionDef2 != null) {
                this.createNewGenerationVersion(versionName, svc, versionDef2);
                continue;
            }
            this.createOldStyleVersion(versionName, svc, declaration);
        }
    }

    private service findService(TypeElement type) {
        service svc = null;
        for (Element it = type; it != null && svc == null; it = it.getEnclosingElement()) {
            svc = it.getAnnotation(service.class);
        }
        if (svc == null) {
            PackageElement pkg = Platform.getElementUtils().getPackageOf(type);
            while (svc == null && pkg != null) {
                svc = pkg.getAnnotation(service.class);
                String pkgName = pkg.getQualifiedName().toString();
                int index = pkg.getQualifiedName().toString().lastIndexOf(46);
                if (index != -1) {
                    pkg = Platform.getPackage(pkgName.substring(0, pkgName.lastIndexOf(46)));
                    continue;
                }
                pkg = null;
            }
        }
        return svc;
    }

    private Iterable<TypeElement> getVersionDeclarations() {
        ArrayList<TypeElement> versionDeclarations = new ArrayList<TypeElement>();
        for (TypeElement el : Platform.getRootElements()) {
            Element ee = el.getEnclosingElement();
            if ((!(ee instanceof PackageElement) || !Versions.isVersionsContainer(((PackageElement)ee).getQualifiedName().toString())) && !Versions.isVersionsContainer(el.getQualifiedName().toString())) continue;
            versionDeclarations.add(el);
        }
        return versionDeclarations;
    }

    private static Product getProduct(nsDescription nsDescription2) {
        try {
            nsDescription2.product();
        }
        catch (MirroredTypeException mte) {
            TypeMirror typeMirror = mte.getTypeMirror();
            return VersionsLoader.getProduct((TypeElement)Platform.getTypeUtils().asElement(typeMirror));
        }
        throw new RuntimeException("Missing product in nsDescription");
    }

    private static Product getProduct(TypeElement element) {
        String productName = element.getSimpleName().toString();
        Product product = Product.getProduct(productName);
        if (product == null) {
            featureList features = element.getAnnotation(featureList.class);
            releaseList releaseList2 = element.getAnnotation(releaseList.class);
            if (features == null || releaseList2 == null) {
                throw SyntaxException.at(Platform.getSourcePos(element), "Product '" + productName + "' must provide both @releaseList and @featureList", new Object[0]);
            }
            product = Product.createProduct(productName, releaseList2, features);
        }
        return product;
    }
}

