/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.Versions;
import emitters.model.Feature;
import emitters.model.Maturity;
import emitters.model.Namespace;
import emitters.model.Product;
import emitters.model.ReleaseVersions;
import emitters.model.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vmodl.breakingChanges;
import vmodl.breakingChangesList;
import vmodl.nsConfig;
import vmodl.service;

public class MetaVersion {
    private Map<String, Version> _localVersionMap = new HashMap<String, Version>();
    private final service _service;
    private final Namespace _namespace;
    private final nsConfig _nsConfig;
    private final Product _product;
    private final String _versionsPrefix;
    private String _wireNs;
    private List<ReleaseVersions> _releaseVersions;
    private final List<MetaVersion> _metaParents = new ArrayList<MetaVersion>();
    private final List<Version> _syntheticVersions = new ArrayList<Version>();
    private Version _devVersion;
    private Version _disabledVersion;
    private Version _latestLtsVersion;
    private Map<String, Feature> _features = null;
    private Map<String, Integer> _breakingChanges = new HashMap<String, Integer>();

    public MetaVersion(service service2, Namespace namespace, nsConfig nsConfig2, breakingChangesList breakingChanges) {
        this._service = service2;
        this._namespace = namespace;
        this._nsConfig = nsConfig2;
        this._product = namespace.getProduct();
        this._versionsPrefix = namespace.getName() + ".version.";
        if (breakingChanges != null) {
            this.setBreakingChanges(breakingChanges);
        }
    }

    public void init() {
        assert (this._syntheticVersions.size() == 0);
        this._releaseVersions = this._namespace.getReleaseVersionsList();
        Version lastLTS = this._releaseVersions.get(0).ltsVersion();
        this._wireNs = lastLTS.getWireNs();
        this._devVersion = new Version(this, "unstable", Version.Kind.DEV);
        this._disabledVersion = new Version(this, "disabled", Version.Kind.DISABLED);
        this._latestLtsVersion = lastLTS;
        this.setupProductProposedParents();
        this._devVersion.addDirectParent(this._latestLtsVersion);
        this.createFeatureVersions(lastLTS, this._devVersion, this._product.getLtsFeatures());
        this.createFeatureVersions(lastLTS, this._devVersion, this._product.getDevFeatures());
        this._syntheticVersions.add(this._devVersion);
        this._syntheticVersions.add(this._disabledVersion);
        this._disabledVersion.addDirectParent(this._devVersion);
    }

    static boolean isLtsVersion(Version version) {
        return version.getKind() == Version.Kind.LTS && version.getSimpleName().charAt(0) != 'm';
    }

    private void setupProductProposedParents() {
        Version ltsVersion = null;
        for (int i = 0; i < this._releaseVersions.size() && ltsVersion == null; ++i) {
            ReleaseVersions release = this._releaseVersions.get(i);
            if (release.ltsVersion() == null || ltsVersion != null) continue;
            ltsVersion = release.ltsVersion();
            if (this._latestLtsVersion != null) continue;
            this._latestLtsVersion = ltsVersion;
        }
    }

    private void adoptMetaChild(MetaVersion metaChild) {
        metaChild._devVersion.addDirectParent(this._devVersion);
        metaChild._disabledVersion.addDirectParent(this._disabledVersion);
        String versionsPrefix = metaChild._versionsPrefix;
        this.adoptChildFeatures(versionsPrefix, this._product.getLtsFeatures());
        this.adoptChildFeatures(versionsPrefix, this._product.getDevFeatures());
    }

    private void adoptChildFeatures(String metaChildPackage, Set<Feature> features) {
        for (Feature desc : features) {
            Version parentFeature;
            Version childFeature = Versions.getVersion(metaChildPackage + desc.id);
            if (childFeature == null || (parentFeature = Versions.getVersion(this._versionsPrefix + desc.id)) == null) continue;
            childFeature.addDirectParent(parentFeature);
        }
    }

    private void createFeatureVersions(Version baseVersion, Version hostVersion, Set<Feature> features) {
        if (features.size() == 0) {
            return;
        }
        if (hostVersion == null) {
            throw new RuntimeException("Feature versions need a base version");
        }
        if (baseVersion == null) {
            throw new RuntimeException("Feature versions need a non-null base version");
        }
        HashSet<Version> newDirectParents = new HashSet<Version>();
        for (Feature feature2 : features) {
            Version featureVersion = this.getFeatureVersion(feature2);
            if (featureVersion.getDirectParents().size() == 0) {
                featureVersion.addDirectParent(baseVersion);
            }
            newDirectParents.add(featureVersion);
        }
        for (Version featureParent : newDirectParents) {
            if (featureParent.getDirectChildren().size() != 0) continue;
            hostVersion.addDirectParent(featureParent);
        }
    }

    private Version getFeatureVersion(Feature feature2) {
        Version version = this._localVersionMap.get(feature2.id);
        if (version != null) {
            return version;
        }
        version = new Version(this, feature2.id, Version.Kind.FEATURE);
        this._localVersionMap.put(feature2.id, version);
        this._syntheticVersions.add(version);
        for (Feature parentFeature : feature2.parents) {
            version.addDirectParent(this.getFeatureVersion(parentFeature));
        }
        return version;
    }

    public void addMetaParent(MetaVersion metaParent) {
        if (this._namespace.equals(metaParent._namespace)) {
            throw new RuntimeException("Invalid referral to the same namespace as a parent in " + this._namespace + " meta-version");
        }
        this._metaParents.add(metaParent);
        metaParent.adoptMetaChild(this);
    }

    public List<ReleaseVersions> getReleaseVersions() {
        return this._releaseVersions;
    }

    private void setBreakingChanges(breakingChangesList l) {
        for (breakingChanges e : l.value()) {
            this._breakingChanges.put(e.branch(), e.count());
        }
    }

    public Maturity getFeatureMaturity(String featureName) {
        Feature feature2 = this._product != null ? this._product.getFeature(featureName) : this._features.get(featureName);
        return feature2 != null ? feature2.maturity : null;
    }

    public Version getFeatureVersion(String featureName, Maturity level) {
        Version featureVersion = Versions.getVersion(this._versionsPrefix + featureName);
        if (featureVersion == null) {
            throw new RuntimeException("The feature version '" + featureName + "' is undefined in namespace " + this._namespace.getName());
        }
        featureVersion.setUsed();
        return featureVersion;
    }

    public Set<Version> pruneUnusedFeatures() {
        HashSet<Version> unusedFeatures = new HashSet<Version>();
        for (int i = this._syntheticVersions.size() - 1; i >= 0; --i) {
            Version version = this._syntheticVersions.get(i);
            if (version.getKind() != Version.Kind.FEATURE || version.isUsed()) continue;
            unusedFeatures.add(version);
            this._syntheticVersions.remove(i);
        }
        return unusedFeatures;
    }

    public Set<Map.Entry<String, Integer>> getBreakingChanges() {
        return this._breakingChanges.entrySet();
    }

    public service getService() {
        return this._service;
    }

    public Namespace getNamespace() {
        return this._namespace;
    }

    public nsConfig getNsConfig() {
        return this._nsConfig;
    }

    public Product getProduct() {
        return this._product;
    }

    public String getVersionsPrefix() {
        return this._versionsPrefix;
    }

    public String getWireNs() {
        return this._wireNs;
    }

    public List<MetaVersion> getMetaParents() {
        return this._metaParents;
    }

    public List<Version> getSyntheticVersions() {
        return this._syntheticVersions;
    }

    public Version getDevVersion() {
        return this._devVersion;
    }

    public Version getDisabledVersion() {
        return this._disabledVersion;
    }

    public Version getLatestLtsVersion() {
        return this._latestLtsVersion;
    }
}

