/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class PromiseUtils {
    public static <T> Promise<T> toPromise(CompletableFuture<T> future) {
        PromiseImpl promise = new PromiseImpl();
        future.whenComplete((result, fault) -> {
            if (fault != null) {
                fault = PromiseUtils.getCause(fault);
                promise.setError(Exceptions.wrap((Throwable)fault));
                return;
            }
            promise.setResult(result);
        });
        return promise;
    }

    public static <T> CompletableFuture<T> toFuture(Promise<T> promise) {
        CompletableFuture future = new CompletableFuture();
        promise.onSuccess(future::complete).onError(future::completeExceptionally);
        return future;
    }

    private static Throwable getCause(Throwable throwable) {
        Throwable result = throwable;
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        while (throwable != null && seen.add(throwable)) {
            result = throwable;
            throwable = throwable.getCause();
        }
        return result;
    }
}

