/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.updates;

import com.vmware.srm.client.topology.client.vmomi.updates.PcUpdateResult;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class PcUpdateResultImpl
implements PcUpdateResult {
    final Set<PropertyCollector.FilterUpdate> _filterUpdates = new HashSet<PropertyCollector.FilterUpdate>();

    public PcUpdateResultImpl(Collection<PropertyCollector.FilterUpdate> updates) {
        Validate.notEmpty(updates, (String)"Updates cannot be null nor empty!");
        updates.forEach(this::replaceNullWithEmpty);
        this._filterUpdates.addAll(updates);
    }

    @Override
    public Set<PropertyCollector.FilterUpdate> getFilterUpdates() {
        return this._filterUpdates;
    }

    @Override
    public Set<PropertyCollector.ObjectUpdate> getObjectUpdates() {
        HashSet<PropertyCollector.ObjectUpdate> objUpdates = new HashSet<PropertyCollector.ObjectUpdate>();
        this._filterUpdates.forEach(update -> {
            if (update.objectSet.length > 0) {
                objUpdates.addAll(Arrays.asList(update.objectSet));
            }
        });
        return objUpdates;
    }

    @Override
    public Set<PropertyCollector.Change> getChanges() {
        HashSet<PropertyCollector.Change> changes = new HashSet<PropertyCollector.Change>();
        this._filterUpdates.forEach(update -> Arrays.stream(update.objectSet).forEach(objectUpdate -> {
            if (objectUpdate.changeSet.length > 0) {
                changes.addAll(Arrays.asList(objectUpdate.changeSet));
            }
        }));
        return changes;
    }

    @Override
    public Set<PropertyCollector.MissingObject> getMissingObjects() {
        HashSet<PropertyCollector.MissingObject> missingObjects = new HashSet<PropertyCollector.MissingObject>();
        this._filterUpdates.forEach(update -> {
            if (update.missingSet.length > 0) {
                missingObjects.addAll(Arrays.asList(update.missingSet));
            }
        });
        return missingObjects;
    }

    private void replaceNullWithEmpty(PropertyCollector.FilterUpdate update) {
        if (update.missingSet == null) {
            update.missingSet = new PropertyCollector.MissingObject[0];
        }
        if (update.objectSet == null) {
            update.objectSet = new PropertyCollector.ObjectUpdate[0];
        } else {
            Arrays.stream(update.objectSet).forEach(objectUpdate -> {
                if (objectUpdate.changeSet == null) {
                    objectUpdate.changeSet = new PropertyCollector.Change[0];
                }
            });
        }
    }
}

