/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrFault;
import com.vmware.vr.client.impex.tool.HmsConfigurablesWrapper;
import com.vmware.vr.client.impex.tool.HmsImpexStages;
import com.vmware.vr.client.impex.tool.HmsJaxbContextLoader;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.tool.ImpexImportHmsContext;
import com.vmware.vr.client.impex.tool.ImpexStageExecutor;
import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.workflow.UserInteractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlImporter.class);

    public Promise<Void> importHmsConfigurables(HmsServersDataWrapper hmsServersDataWrapper, File file) {
        LOGGER.info("Importing VR data.");
        HmsConfigurablesWrapper hmsConfigurablesWrapper = this.readConfigurables(file);
        try {
            return ImpexImportHmsContext.executeWith(this::importHmsConfigurables, hmsServersDataWrapper, hmsConfigurablesWrapper);
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
    }

    private Promise<Void> importHmsConfigurables() {
        LOGGER.info("Import VR configurables started.");
        return new HmsCmdStageExecutor().start().thenApply(unused -> {
            this.summaryVrImportResult();
            return null;
        });
    }

    private void summaryVrImportResult() {
        String summary = ImpexImportHmsContext.get().getErrors().isEmpty() ? String.format("Import VR configurables ended. Imported: %s.", ImpexImportHmsContext.get().getAndResetImportedGroupName().size()) : String.format("Import VR configurables ended. Imported: %s, Un-imported: %s.", ImpexImportHmsContext.get().getAndResetImportedGroupName().size(), ImpexImportHmsContext.get().getErrors().size());
        LOGGER.info(summary);
        ImpexImportHmsContext.get().getAndResetErrors();
        ImpexImportHmsContext.get().clearDatastoreInfoCache();
        ImpexImportHmsContext.get().clearParentDatacenterCache();
    }

    private HmsConfigurablesWrapper readConfigurables(File file) {
        HmsConfigurablesWrapper configurables;
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File does not exist %s.", file.getAbsoluteFile()));
        }
        IOHelper ioHelper = UserInteractor.getIoHelper();
        ioHelper.writeln("Reading file...");
        try (FileInputStream inputStream = new FileInputStream(file);){
            configurables = HmsJaxbContextLoader.unmarshal(inputStream);
        }
        catch (IOException | JAXBException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        ioHelper.writeln("Reading file done.");
        return configurables;
    }

    private static final class HmsCmdStageExecutor
    extends CmdStageExecutor {
        private HmsCmdStageExecutor() {
        }

        @Override
        protected ImpexStageExecutor.ImpexStage initialStage() {
            return new HmsImpexStages.ServersDataCollector(new ImpexStageExecutor.StageParams());
        }

        @Override
        protected Void stageComplete(ImpexStageExecutor.ImpexStage stage, ImpexStageExecutor.ImpexStage nextStage, Void context) {
            this.logWarnings(ImpexImportHmsContext.get().getErrors());
            return context;
        }

        @Override
        protected void stageFailed(ImpexStageExecutor.ImpexStage stage, Exception cause, Void context) {
            this.logWarnings(ImpexImportHmsContext.get().getErrors());
        }
    }

    private static abstract class CmdStageExecutor
    extends ImpexStageExecutor<Void> {
        private CmdStageExecutor() {
        }

        @Override
        protected abstract ImpexStageExecutor.ImpexStage initialStage();

        @Override
        protected abstract Void stageComplete(ImpexStageExecutor.ImpexStage var1, ImpexStageExecutor.ImpexStage var2, Void var3);

        @Override
        protected abstract void stageFailed(ImpexStageExecutor.ImpexStage var1, Exception var2, Void var3);

        protected void logWarnings(List<DrFault> faults) {
            if (faults.size() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (DrFault fault : faults) {
                sb.append('\n').append(fault.getMessage()).append(' ');
                String detail = fault.getDetail();
                if (detail == null) continue;
                sb.append(detail);
            }
            if (sb.length() > 0) {
                LOGGER.warn("Collected the following warnings:{}", (Object)sb);
            }
        }
    }
}

