/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.remotelogin;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.infrastructure.oauth2.remotelogin.RemoteLoginRequestVerifier;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLoginRequestServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLoginRequestServlet.class);
    public static final String REQ_ID_PARAM = "requestid";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestId = request.getParameter(REQ_ID_PARAM);
        if (StringUtils.isEmpty((String)requestId)) {
            response.sendError(400);
            return;
        }
        LOGGER.info("Received requestid {}", (Object)requestId);
        Configurator configurator = InitFilter.getConfigurator(request);
        RemoteLoginRequestController controller = new RemoteLoginRequestController(request, response, configurator, requestId);
        controller.start(Config.get().getResponseTimeout());
    }

    private static class RemoteLoginRequestController
    extends BaseAsyncController {
        private final Configurator _configurator;
        private final String _requestId;

        public RemoteLoginRequestController(HttpServletRequest request, HttpServletResponse response, Configurator configurator, String requestId) {
            super(request, response);
            this._configurator = configurator;
            this._requestId = requestId;
        }

        @Override
        protected BaseAsyncController.HttpProcessStage createPipeline() {
            return this::verifyRequest;
        }

        Stream<BaseAsyncController.HttpProcessStage> verifyRequest() {
            return this._configurator.getOAuth2Strategy().thenApply(OAuth2AuthenticationStrategy.class::cast).thenCompose(strategy -> {
                Objects.requireNonNull(strategy, "OAuth2 strategy is null");
                return strategy.getRemoteLoginVerifier().verify(this._requestId).thenApply(spec -> () -> this.completeRequest((OAuth2AuthenticationStrategy)strategy, (RemoteLoginRequestVerifier.RequestSpec)spec));
            }).toStream();
        }

        Stream<BaseAsyncController.HttpProcessStage> completeRequest(OAuth2AuthenticationStrategy strategy, RemoteLoginRequestVerifier.RequestSpec spec) {
            Promise result;
            try {
                result = strategy.startRemoteLogin(this._request, this._response, this._requestId, spec.authResponseEndpoint);
            }
            catch (Exception exc) {
                LOGGER.warn("Failed to start remote login for {}", (Object)this._requestId, (Object)exc);
                result = Promises.reject((Exception)exc);
            }
            return result.toStream().flatMap(unused -> Streams.empty());
        }
    }
}

