/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.localization.catalogManager;

import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.infrastructure.localization.catalogManager.CatalogLoader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.Validate;

public class CatalogLookup {
    private static ResourceBundle.Control LOCALE_CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private final CatalogLoader.Lookup _lookup;
    private final Locale _defaultLocale;
    private final Map<String, String> _defaultResourceMap;

    private static List<Locale> getLocales(Locale locale) {
        return LOCALE_CONTROL.getCandidateLocales("dummy.properties", locale);
    }

    private static Map<String, String> getResourceMap(Locale locale, CatalogLoader.Lookup lookup) {
        for (Locale candidate : CatalogLookup.getLocales(locale)) {
            Map resourceMap = (Map)lookup.get(candidate);
            if (resourceMap == null) continue;
            return resourceMap;
        }
        return Collections.emptyMap();
    }

    public CatalogLookup(CatalogLoader.Lookup lookup, Locale defaultLocale) {
        this._lookup = lookup;
        this._defaultLocale = defaultLocale;
        this._defaultResourceMap = CatalogLookup.getResourceMap(defaultLocale, lookup);
    }

    public String getLocalizedMessage(Locale locale, String key) {
        Map<String, String> resourceMap;
        String value;
        Validate.notNull((Object)"key", (String)key);
        if (locale == null) {
            locale = this._defaultLocale;
        }
        if ((value = (resourceMap = CatalogLookup.getResourceMap(locale, this._lookup)).get(key)) == null && resourceMap != this._defaultResourceMap) {
            value = this._defaultResourceMap.get(key);
        }
        if (value == null) {
            return key;
        }
        return StringUtils.trimQuotes((String)value);
    }
}

