/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.tasks;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.tasks.ComposableTask;
import com.vmware.srm.client.infrastructure.tasks.TasksFacade;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ParallelTasksExecutor {
    public static Promise<ManagedObjectReference> runTasks(Set<ComposableTask> tasks, ServersView view) {
        if (CollectionUtils.isEmpty(tasks)) {
            return Promises.resolve(null);
        }
        if (tasks.size() == 1) {
            return tasks.iterator().next().run();
        }
        List<Promise> runningTasks = tasks.stream().map(ComposableTask::run).collect(Collectors.toList());
        return Promises.all((Promise[])runningTasks.toArray(new Promise[0])).thenApply(tasksResult -> {
            ManagedObjectReference[] taskRefs = (ManagedObjectReference[])runningTasks.stream().map(arg_0 -> ((Promises.ResultAccessor)tasksResult).getResult(arg_0)).filter(Objects::nonNull).toArray(ManagedObjectReference[]::new);
            if (taskRefs.length == 1) {
                return taskRefs[0];
            }
            HashSet<ManagedObjectReference> vmomi = new HashSet<ManagedObjectReference>();
            HashSet<ManagedObjectReference> managed = new HashSet<ManagedObjectReference>();
            for (ManagedObjectReference ref : taskRefs) {
                if (TasksFacade.isManagedTask(ref)) {
                    managed.add(ref);
                    continue;
                }
                vmomi.add(ref);
            }
            managed.add(TasksFacade.createSrmOrVcMultiTask(view, vmomi.toArray(new ManagedObjectReference[0])));
            return TasksFacade.createCompositeMultiTask(managed.toArray(new ManagedObjectReference[0]));
        });
    }
}

