/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.version.impl;

import com.vmware.vim.vmomi.client.common.RequestConfiguration;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.common.impl.DownloadRequest;
import com.vmware.vim.vmomi.client.version.VersionProvider;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.util.XmlSecurity;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServiceXmlVersionProvider
implements VersionProvider {
    private static final Log LOG = LogFactory.getLog(ServiceXmlVersionProvider.class);
    private static final int BYTES_TO_SKIP = 1024;
    private final URI location;
    private final RequestConfiguration requestConfig;
    private final Parser parser;
    private final Picker picker;

    private ServiceXmlVersionProvider(URI location, RequestConfiguration requestConfig, Parser parser, Picker picker) {
        this.location = location;
        this.requestConfig = requestConfig;
        this.parser = parser;
        this.picker = picker;
    }

    @Override
    public CompletionStage<VmodlVersion> getVersionAsync(VersionProvider.GetVersionSpec spec) {
        CompletableFuture<VmodlVersion> future = new CompletableFuture<VmodlVersion>();
        DownloadRequest req = new DownloadRequest(this.location, this.requestConfig);
        VmodlVersionMap clientVersions = spec.getContext().getVmodlVersionMap();
        ServiceVersionsXmlResponse resp = new ServiceVersionsXmlResponse(future, clientVersions);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Downloading %s", this.location));
        }
        spec.getProtocolBinding().send(req, resp);
        return future;
    }

    static void skipAll(InputStream input) {
        try {
            long skipped;
            while ((skipped = input.skip(1024L)) >= 1024L) {
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"Exception thrown while trying to skip through a stream's content", (Throwable)e);
        }
    }

    public static class Builder {
        private final URI location;
        private RequestConfiguration requestConfig;
        private Parser parser;
        private Picker picker;
        private boolean internal;

        public Builder(URI location) {
            this.location = Objects.requireNonNull(location);
        }

        public Builder setParser(Parser parser) {
            this.parser = parser;
            return this;
        }

        public Builder setPicker(Picker picker) {
            this.picker = picker;
            return this;
        }

        public Builder setInternal(boolean internal2) {
            this.internal = internal2;
            return this;
        }

        public Builder setRequestConfiguration(RequestConfiguration requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        public ServiceXmlVersionProvider build() {
            return new ServiceXmlVersionProvider(this.location, this.requestConfig, this.parser == null ? DefaultParser.INSTANCE : this.parser, this.picker == null ? (this.internal ? DefaultPicker.INTERNAL : DefaultPicker.PUBLIC) : this.picker);
        }
    }

    static class DefaultPicker
    implements Picker {
        static DefaultPicker PUBLIC = new DefaultPicker(false);
        static DefaultPicker INTERNAL = new DefaultPicker(true);
        private final boolean internal;

        private DefaultPicker(boolean internal2) {
            this.internal = internal2;
        }

        @Override
        public VmodlVersion pick(VmodlVersionMap clientVersions, ServiceVersions serviceVersions) {
            List<String> serviceVersionIds = serviceVersions.getIds();
            VmodlVersion result = null;
            for (String id : serviceVersionIds) {
                result = clientVersions.findVersion(serviceVersions.getWsdlNamespace(), id, this.internal);
                if (result == null) continue;
                return result;
            }
            throw new Picker.NoMatchException();
        }
    }

    static class DefaultParser
    implements Parser {
        static DefaultParser INSTANCE = new DefaultParser();

        DefaultParser() {
        }

        @Override
        public ServiceVersions parse(InputStream content) {
            try {
                return this.doParse(content);
            }
            catch (Parser.ParseException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new Parser.ParseException(e);
            }
        }

        private ServiceVersions doParse(InputStream content) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
            DocumentBuilder docBuilder = XmlSecurity.XML_PARSER_FACTORY.newDocumentBuilder();
            Document doc = docBuilder.parse(content);
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            Node ns = (Node)xpath.evaluate("/namespaces/namespace", doc, XPathConstants.NODE);
            if (ns == null) {
                throw new Parser.ParseException("No /namespaces/namespace element present");
            }
            String currentVersion = xpath.evaluate("version", ns);
            String wsdlNamespaceWithUrn = xpath.evaluate("name", ns);
            if (wsdlNamespaceWithUrn == null || wsdlNamespaceWithUrn.length() == 0) {
                throw new Parser.ParseException("'name' element not present in namespace");
            }
            if (!wsdlNamespaceWithUrn.startsWith("urn:")) {
                throw new Parser.ParseException(String.format("namespace's name '%s' is invalid", wsdlNamespaceWithUrn));
            }
            final String wsdlNamespace = wsdlNamespaceWithUrn.substring("urn:".length());
            NodeList priorVersions = (NodeList)xpath.evaluate("priorVersions/version", ns, XPathConstants.NODESET);
            final ArrayList<String> versions2 = new ArrayList<String>(priorVersions.getLength() + 1);
            if (currentVersion != null && currentVersion.length() > 0) {
                versions2.add(currentVersion);
            }
            int n = priorVersions.getLength();
            for (int i = 0; i < n; ++i) {
                String priorVersion = priorVersions.item(i).getTextContent();
                if (priorVersion == null || priorVersion.length() <= 0) continue;
                versions2.add(priorVersion);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("XML parsed; wsdlNamespace = %s, versions = %s", wsdlNamespace, versions2));
            }
            return new ServiceVersions(){

                @Override
                public String getWsdlNamespace() {
                    return wsdlNamespace;
                }

                @Override
                public List<String> getIds() {
                    return versions2;
                }
            };
        }
    }

    private class ServiceVersionsXmlResponse
    implements Response {
        private final VmodlVersionMap clientVersions;
        private final CompletableFuture<VmodlVersion> future;

        public ServiceVersionsXmlResponse(CompletableFuture<VmodlVersion> future, VmodlVersionMap clientVersions) {
            this.clientVersions = clientVersions;
            this.future = future;
        }

        @Override
        public void setResponse(Response.Status status, InputStream body) {
            if (status != Response.Status.Ok) {
                ServiceXmlVersionProvider.skipAll(body);
                RuntimeException e = status == Response.Status.NotFound ? new VersionProvider.UnsupportedNegotiationMechanismException() : new UnexpectedStatusCodeException(status.getCode());
                this.setError(e);
                return;
            }
            try {
                ServiceVersions serviceVersions = ServiceXmlVersionProvider.this.parser.parse(body);
                VmodlVersion result = ServiceXmlVersionProvider.this.picker.pick(this.clientVersions, serviceVersions);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Version %s picked after parsing %s", result, ServiceXmlVersionProvider.this.location));
                }
                this.future.complete(result);
            }
            catch (Exception e) {
                ServiceXmlVersionProvider.skipAll(body);
                this.setError(e);
            }
        }

        @Override
        public void setError(Exception e) {
            this.future.completeExceptionally(e);
        }
    }

    public static interface ServiceVersions {
        public String getWsdlNamespace();

        public List<String> getIds();
    }

    public static interface Picker {
        public VmodlVersion pick(VmodlVersionMap var1, ServiceVersions var2);

        public static class NoMatchException
        extends RuntimeException {
        }
    }

    public static interface Parser {
        public ServiceVersions parse(InputStream var1);

        public static class ParseException
        extends RuntimeException {
            public ParseException(String message) {
                super(message);
            }

            public ParseException(Throwable cause) {
                super(cause);
            }
        }
    }
}

