/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.version.impl;

import com.vmware.vim.vmomi.client.version.VersionProvider;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class StaticVersionProvider
implements VersionProvider {
    private final VmodlVersion version;

    public StaticVersionProvider(VmodlVersion version) {
        this.version = Objects.requireNonNull(version);
    }

    public StaticVersionProvider(Class<?> version) {
        this(version, null);
    }

    public StaticVersionProvider(Class<?> version, VmodlContext context) {
        if (context == null) {
            context = VmodlContext.getContext();
        }
        this.version = context.getVmodlVersionMap().getVersion(version);
        if (version == null) {
            throw new IllegalArgumentException(String.format("Version class '%1$s' is not present in the VMODL context", version));
        }
    }

    @Override
    public CompletionStage<VmodlVersion> getVersionAsync(VersionProvider.GetVersionSpec spec) {
        return CompletableFuture.completedFuture(this.version);
    }
}

