/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.af.interop;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.SystemUtils;

public abstract class NativeAdapter {
    static {
        String propName = "jna.library.path";
        String LINUX_VMDIR_LIB64_PATH = "/usr/lib/vmware-vmafd/lib64";
        String LINUX_LIKEWISE_LIB64_PATH = "/opt/likewise/lib64";
        List<String> paths = null;
        if (!SystemUtils.IS_OS_LINUX) {
            throw new IllegalStateException("Only Linux is supported");
        }
        paths = Arrays.asList("/usr/lib/vmware-vmafd/lib64", "/opt/likewise/lib64");
        for (String pathString : paths) {
            Path path = Paths.get(pathString, new String[0]);
            if (!Files.notExists(path, new LinkOption[0])) continue;
            throw new IllegalStateException("Path \"" + pathString + "\" does not exist");
        }
        String propValue = System.getProperty("jna.library.path");
        StringBuilder jnalibpath = new StringBuilder(propValue == null ? "" : propValue);
        for (String path : paths) {
            File libDir = new File(path);
            if (!libDir.exists() || !libDir.isDirectory()) continue;
            if (jnalibpath.length() > 0) {
                jnalibpath.append(File.pathSeparator);
            }
            jnalibpath.append(path);
        }
        propValue = jnalibpath.substring(0);
        if (!propValue.isEmpty()) {
            System.setProperty("jna.library.path", propValue);
        }
    }
}

