/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.arrayManagers;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.arrayManagers.ArrayPairConverter;
import com.vmware.srm.client.impex.configurables.arrayManagers.ConnectionSpecConverter;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeArrayManager;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeConnectionSpec;
import com.vmware.srm.client.impex.configurables.arrayManagers.IeStorageAdapter;
import com.vmware.srm.client.impex.configurables.arrayManagers.KeyValueConverter;
import com.vmware.srm.client.impex.configurables.arrayManagers.StorageAdapterConverter;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.storage.AdapterConnectionSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.storage.REPLICATED_ARRAY_PAIR;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayManagerConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayManagerConverter.class);

    public static PropertyCollector.FilterSpec getFilterSpec(ManagedObjectReference storageManager) {
        PropertyCollector.PropertySpec storageManagerSpec = PCUtil.createPropertySpec((String)"DrStorageStorageManager", (String[])new String[]{"arrayManager"});
        PropertyCollector.PropertySpec arrayManagerSpec = PCUtil.createPropertySpec((String)"DrStorageArrayManager", (String[])new String[]{"name", "arrayPair", "adapter", "connectionSpec"});
        PropertyCollector.PropertySpec adapterSpec = PCUtil.createPropertySpec((String)"DrStorageStorageAdapter", (String[])new String[]{"info", "arrayModel", "replicationSoftware"});
        PropertyCollector.PropertySpec arrayPairSpec = PCUtil.createPropertySpec((String)"DrStorageReplicatedArrayPair", (String[])new String[]{REPLICATED_ARRAY_PAIR.INFO_.KEY, REPLICATED_ARRAY_PAIR.PEER_.ARRAY_ID});
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(storageManager);
        ObjectSpecBuilder.TraversalSpecBuilder rootTraversal = specBuilder.traverseTo("arrayManager");
        rootTraversal.traverseTo("DrStorageArrayManager", "arrayPair");
        rootTraversal.traverseTo("DrStorageArrayManager", "adapter");
        return new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{storageManagerSpec, arrayManagerSpec, adapterSpec, arrayPairSpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
    }

    public static List<IeArrayManager> fromVmodl(ManagedObjectReference storageManager, PcResult pcResult, boolean local) {
        if (pcResult == null) {
            return Collections.emptyList();
        }
        Object[] arrayManagers = (ManagedObjectReference[])pcResult.getProperty(storageManager, "arrayManager");
        if (ArrayUtils.isEmpty((Object[])arrayManagers)) {
            return Collections.emptyList();
        }
        return Arrays.stream(arrayManagers).map(arrayManager -> ArrayManagerConverter.convertArrayManager(arrayManager, pcResult, local)).collect(Collectors.toList());
    }

    public static AdapterConnectionSpec[] connectionSpecToVmodl(IeConnectionSpec[] ieConnectionSpecs, String username, String password, String amName) {
        if (ieConnectionSpecs == null) {
            LOGGER.debug("IeConnectionSpecs are null for AM: {}.", (Object)amName);
            return null;
        }
        return (AdapterConnectionSpec[])Arrays.stream(ieConnectionSpecs).map(spec -> new AdapterConnectionSpec(spec.getKey(), KeyValueConverter.toVmodl(spec.getAddress()), username, password, KeyValueConverter.toVmodl(spec.getOpaque()))).toArray(AdapterConnectionSpec[]::new);
    }

    private static IeArrayManager convertArrayManager(ManagedObjectReference arrayManager, PcResult pcResult, boolean local) {
        IeArrayManager ieArrayManager = new IeArrayManager();
        if (pcResult == null) {
            return ieArrayManager;
        }
        ArrayManagerConverter.setBasicSettings(ieArrayManager, arrayManager, pcResult);
        ManagedObjectReference[] arrayPairs = (ManagedObjectReference[])pcResult.getProperty(arrayManager, "arrayPair");
        ieArrayManager.setArrayPairs(ArrayPairConverter.fromVmodl(arrayPairs, pcResult));
        AdapterConnectionSpec[] specs = (AdapterConnectionSpec[])pcResult.getProperty(arrayManager, "connectionSpec");
        ieArrayManager.setConnectionSpec(ConnectionSpecConverter.fromVmodl(specs));
        ieArrayManager.setLocal(local);
        return ieArrayManager;
    }

    private static void setBasicSettings(IeArrayManager ieArrayManager, ManagedObjectReference arrayManager, PcResult pcResult) {
        String name = (String)pcResult.getProperty(arrayManager, "name");
        ieArrayManager.setName(name);
        ManagedObjectReference adapter = (ManagedObjectReference)pcResult.getProperty(arrayManager, "adapter");
        IeStorageAdapter ieStorageAdapter = StorageAdapterConverter.fromVmodl(adapter, pcResult);
        ieArrayManager.setStorageAdapter(ieStorageAdapter);
    }
}

