/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.groups;

import com.vmware.srm.client.impex.configurables.groups.HbrProviderSettingsConverter;
import com.vmware.srm.client.impex.configurables.groups.IeProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.ProtectionGroupConverter;
import com.vmware.srm.client.impex.configurables.groups.StorageProviderSettingsConverter;
import com.vmware.srm.client.impex.configurables.groups.VvolProviderSettingsConverter;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VmProtectionGroupConverter<T extends IeVmProtectionGroup>
extends ProtectionGroupConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmProtectionGroupConverter.class);

    public VmProtectionGroupConverter(PcResult pcResult) {
        super(pcResult);
    }

    protected abstract StorageProviderSettingsConverter<T> getStorageProviderSettingsExporter();

    protected abstract HbrProviderSettingsConverter<T> getHbrProviderSettingsExporter();

    protected abstract VvolProviderSettingsConverter<T> getVvolProviderSettingsExporter();

    protected void convertVmPg(ManagedObjectReference vmProtectionGroup, T ieProtectionGroup) {
        this.setBasicSettings(vmProtectionGroup, (IeProtectionGroup)ieProtectionGroup);
        ManagedObjectReference providerMoRef = (ManagedObjectReference)this._pcResult.getProperty(vmProtectionGroup, "provider");
        String type = providerMoRef.getType();
        if ("DrReplicationStorageProvider".equals(type)) {
            this.getStorageProviderSettingsExporter().fromVmodl(ieProtectionGroup, vmProtectionGroup);
        } else if ("DrReplicationHbrProvider".equals(type)) {
            this.getHbrProviderSettingsExporter().fromVmodl(ieProtectionGroup, vmProtectionGroup);
        } else if ("DrReplicationVvolProvider".equals(type)) {
            this.getVvolProviderSettingsExporter().fromVmodl(ieProtectionGroup, vmProtectionGroup);
        } else {
            LOGGER.warn("Unexpected VMPG provider type, provider: {}", (Object)providerMoRef);
        }
    }
}

