/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.inventory.datacenter;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeDistributedVirtualPortgroup;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.vim.Tag;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public class DistributedVirtualPortgroupConverter
implements ConfigurableConverter {
    private static final String UPLINK_PG_TAG = "SYSTEM/DVS.UPLINKPG";

    public static IeDistributedVirtualPortgroup fromVmodl(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference network) {
        if (DistributedVirtualPortgroupConverter.isUplink(network, pcResult)) {
            return null;
        }
        IeDistributedVirtualPortgroup ieDvp = new IeDistributedVirtualPortgroup();
        ieDvp.setId(idBuilder.buildId(network));
        String name = (String)pcResult.getProperty(network, "name");
        ieDvp.setName(name);
        return ieDvp;
    }

    private static boolean isUplink(ManagedObjectReference network, PcResult pcResult) {
        if (!"DistributedVirtualPortgroup".equals(network.getType())) {
            return false;
        }
        Object[] tags = (Tag[])pcResult.tryGetProperty(network, "tag");
        return ArrayUtils.isNotEmpty((Object[])tags) && Arrays.stream(tags).anyMatch(tag -> UPLINK_PG_TAG.equals(tag.key));
    }
}

