/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.mappings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.mappings.IeIPCustomizationRule;
import com.vmware.srm.client.impex.configurables.mappings.IeMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeNetworkMapping;
import com.vmware.srm.client.impex.configurables.mappings.IpCustomizationRuleConverter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.dr.IpSubnetMapper;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkMappingsConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkMappingsConverter.class);

    public static IeNetworkMapping[] fromVmodl(InventoryMapperBase.NetworkMapping[] networkMappings, IpSubnetMapper.IPSubnetMapping[] ipSubnetMappings) {
        if (ArrayUtils.isEmpty((Object[])networkMappings)) {
            return new IeNetworkMapping[0];
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return (IeNetworkMapping[])Arrays.stream(networkMappings).map(mapping -> new IeNetworkMapping(idBuilder.buildId(mapping.primaryObject), idBuilder.buildId(mapping.secondaryObject), IpCustomizationRuleConverter.fromVmodl(ipSubnetMappings, mapping.primaryObject, mapping.secondaryObject))).filter(IeMapping::fromCurrentPair).toArray(IeNetworkMapping[]::new);
    }

    public static Map<InventoryMapperBase.NetworkMapping, IeIPCustomizationRule[]> toVmodl(IeNetworkMapping[] networkMappings, InventoryExtractor.InventoryLookup inventory) {
        if (networkMappings == null) {
            LOGGER.debug("Network mappings are null.");
            return null;
        }
        HashMap<InventoryMapperBase.NetworkMapping, IeIPCustomizationRule[]> mappingToRule = new HashMap<InventoryMapperBase.NetworkMapping, IeIPCustomizationRule[]>();
        for (IeNetworkMapping networkMapping : networkMappings) {
            String primaryId = networkMapping.getPrimary();
            ManagedObjectReference primary = (ManagedObjectReference)inventory.get(primaryId);
            if (primary == null) {
                LOGGER.warn("Primary mapping network {} not found.", (Object)primaryId);
                continue;
            }
            String secondaryId = networkMapping.getSecondary();
            ManagedObjectReference secondary = (ManagedObjectReference)inventory.get(secondaryId);
            if (secondary == null) {
                LOGGER.warn("Secondary mapping network {} not found.", (Object)secondaryId);
                continue;
            }
            LOGGER.info("Adding network mapping with ids {} {}.", (Object)primaryId, (Object)secondaryId);
            IeIPCustomizationRule[] rules = networkMapping.getRules();
            InventoryMapperBase.NetworkMapping mapping = new InventoryMapperBase.NetworkMapping(primary, secondary, null);
            mappingToRule.put(mapping, rules);
        }
        return mappingToRule;
    }
}

