/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.advancedSettings;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.configurables.advancedSettings.AdvancedSettingsConverter;
import com.vmware.srm.client.impex.configurables.advancedSettings.IeSiteAdvancedSettings;
import com.vmware.srm.client.impex.exporters.SingleSiteExporter;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteAdvancedSettingsExporter
extends SingleSiteExporter<IeSiteAdvancedSettings> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteAdvancedSettingsExporter.class);

    @Override
    protected Promise<List<IeSiteAdvancedSettings>> getSingleSiteConfigurables(boolean local) {
        return this.getOptionValues(local).thenApply(optionValues -> new IeSiteAdvancedSettings(local, AdvancedSettingsConverter.fromVmodl(optionValues))).thenApply(Collections::singletonList);
    }

    private Promise<OptionValue[]> getOptionValues(boolean local) {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        ManagedObjectReference optManagerRef = local ? serversData.getLocalContent().optionManager : serversData.getRemoteContent().optionManager;
        String serverGuid = optManagerRef.getServerGuid();
        LOGGER.info("Getting advanced settings for server with guid '{}'.", (Object)serverGuid);
        OptionManager optManager = local ? (OptionManager)((SrmService)((SrmServer)serversData.getLocalPair().server()).service()).createStub(optManagerRef) : (OptionManager)((SrmService)((SrmServer)serversData.getRemotePair().server()).service()).createStub(optManagerRef);
        FuturePromise futurePromise = new FuturePromise();
        optManager.getSetting((Future)futurePromise);
        return futurePromise.onSuccess(aVoid -> LOGGER.info("Successfully got advanced settings for server with guid '{}'.", (Object)serverGuid)).onError(error -> LOGGER.warn("Failed to get advanced settings for server with guid '{}'.", (Object)serverGuid, error));
    }
}

