/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.groups;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.impex.configurables.Configurable;
import com.vmware.srm.client.impex.configurables.folders.IeFolder;
import com.vmware.srm.client.impex.configurables.groups.IeProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeSrmConfigVmProtectionGroup;
import com.vmware.srm.client.impex.importers.folders.FolderImporter;
import com.vmware.srm.client.impex.importers.folders.groups.GroupImporter;
import com.vmware.srm.client.impex.importers.folders.groups.vm.ProtectedVmUpdater;
import com.vmware.srm.client.impex.importers.folders.groups.vm.RecoveryLocationSettingsConverter;
import com.vmware.srm.client.impex.importers.folders.groups.vm.VmGroupImporter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.ArrayManagerUtil;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.vim.binding.dr.Folder;
import com.vmware.vim.binding.dr.fault.DuplicateName;
import com.vmware.vim.binding.dr.replication.ProtectionGroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.replication.PROTECTION_GROUP;
import com.vmware.vim.vmomi.core.Future;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupFolderImporter
extends FolderImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupFolderImporter.class);
    private final ManagedObjectReference _rootFolder;
    private final VmGroupImporter _vmPgCreator;
    private final ProtectedVmUpdater _protectedVmUpdater;

    public GroupFolderImporter(ManagedObjectReference rootFolder, PcResult basicPGsPcResult, VmGroupImporter vmPgCreator, RecoveryLocationSettingsConverter rlsConverter, InventoryExtractor.InventoryLookup inventory) {
        super(IContextUtil.getSrmService(true), basicPGsPcResult);
        Validate.notNull((Object)vmPgCreator);
        this._vmPgCreator = vmPgCreator;
        this._rootFolder = rootFolder;
        this._protectedVmUpdater = new ProtectedVmUpdater(rlsConverter, inventory);
    }

    public Promise<GroupImporter.GroupsLookup> create() {
        ImpexImportSrmContext context = ImpexImportSrmContext.get();
        IeFolder parentFolder = context.getConfigurablesWrapper().getProtectionGroupRootFolder();
        if (parentFolder == null || this._rootFolder == null) {
            LOGGER.warn("Invalid folder format.");
            return Promises.resolve((Object)new GroupImporter.GroupsLookup(Collections.emptyMap()));
        }
        if (CollectionUtils.isEmpty(parentFolder.getChildren())) {
            return Promises.resolve((Object)new GroupImporter.GroupsLookup(Collections.emptyMap()));
        }
        ConcurrentHashMap idToMoRef = new ConcurrentHashMap();
        ManagedObjectReference storageManager = context.getServersDataWrapper().getLocalContent().storageManager;
        return ArrayManagerUtil.getArrayPairKeyToMoRef((ServersView)IContextUtil.getSrmView(), storageManager).thenCompose(arrayPairKeyToMoRef -> this.createFolders(parentFolder, this._rootFolder, idToMoRef, (Map<String, ManagedObjectReference>)arrayPairKeyToMoRef)).thenApply(ready -> new GroupImporter.GroupsLookup(idToMoRef));
    }

    private Promise<Void> createFolders(IeFolder ieParentFolder, ManagedObjectReference parentMoRef, Map<String, ManagedObjectReference> idToMoRef, Map<String, ManagedObjectReference> arrayPairKeyToMoRef) {
        if (ieParentFolder == null || ieParentFolder.getChildren() == null || parentMoRef == null) {
            LOGGER.debug("Group folder, children or parent ref is null.");
            return Promises.resolve(null);
        }
        Stream current = Streams.empty();
        for (Configurable configurable : ieParentFolder.getChildren()) {
            if (configurable instanceof IeFolder) {
                current = current.merge(new Publisher[]{this.processFolder(parentMoRef, (IeFolder)configurable, idToMoRef, arrayPairKeyToMoRef)});
                continue;
            }
            if (configurable instanceof IeSrmConfigVmProtectionGroup) {
                current = current.merge(new Publisher[]{this.processVmPg(parentMoRef, (IeSrmConfigVmProtectionGroup)configurable, idToMoRef, arrayPairKeyToMoRef)});
                continue;
            }
            LOGGER.warn("Unexpected child type '{}'.", (Object)configurable);
        }
        return current.collect().thenApply(unused -> null);
    }

    private Promise<Void> processFolder(ManagedObjectReference parentMoRef, IeFolder childFolder, Map<String, ManagedObjectReference> idToMoRef, Map<String, ManagedObjectReference> arrayPairKeyToMoRef) {
        Folder parent = (Folder)this._srmService.createStub(parentMoRef);
        Promise childPromise = this.createFolder(parentMoRef, parent, childFolder.getName()).onSuccess(folderMoRef -> {
            if (folderMoRef == null) {
                ImpexImportSrmContext.get().addError(ImpexL10N.localize("group.folder", childFolder.getName()));
            }
        });
        return childPromise.thenCompose(child -> this.createFolders(childFolder, (ManagedObjectReference)child, idToMoRef, arrayPairKeyToMoRef));
    }

    private Promise<Void> processVmPg(ManagedObjectReference parentMoRef, IeSrmConfigVmProtectionGroup ieVmPg, Map<String, ManagedObjectReference> idToMoRef, Map<String, ManagedObjectReference> arrayPairKeyToMoRef) {
        return this._vmPgCreator.createVmProtectionGroup(ieVmPg, parentMoRef, arrayPairKeyToMoRef).materialize().thenCompose(vmPgPromiseResult -> this.getPgPromise((PromiseResult<ManagedObjectReference>)vmPgPromiseResult, ieVmPg, parentMoRef, idToMoRef)).materialize().thenCompose(result -> {
            if (!result.isSuccessful()) {
                String message = ImpexL10N.localize("group.create.vmpg", ieVmPg.getName());
                LOGGER.warn(message, (Throwable)result.getError());
                ImpexImportSrmContext.get().addError(message, result.getError());
                return Promises.resolve(null);
            }
            return this._vmPgCreator.protectVms(ieVmPg, (ManagedObjectReference)result.getResult());
        }).materialize().thenApply(result -> null);
    }

    private Promise<ManagedObjectReference> getPgPromise(PromiseResult<ManagedObjectReference> pgPromiseResult, IeProtectionGroup iePg, ManagedObjectReference parent, Map<String, ManagedObjectReference> idToMoRef) {
        String name = iePg.getName();
        String id = iePg.getId();
        if (pgPromiseResult.isSuccessful()) {
            LOGGER.info("ProtectionGroup '{}' was created successfully.", (Object)name);
            ManagedObjectReference pgMoRef2 = (ManagedObjectReference)pgPromiseResult.getResult();
            if (!iePg.isProtectedSiteLocal()) {
                Promise<ProtectionGroup.Peer> peerPromise = this.peerProtectionGroup(pgMoRef2, false);
                return peerPromise.thenApply(peer -> {
                    idToMoRef.put(id, peer.getGroup());
                    return pgMoRef2;
                });
            }
            idToMoRef.put(id, pgMoRef2);
            return Promises.resolve((Object)pgMoRef2);
        }
        LOGGER.warn("Failed to create ProtectionGroup '{}', error: '{}'.", (Object)name, (Object)pgPromiseResult.getError());
        if (pgPromiseResult.getError() instanceof DuplicateName) {
            ManagedObjectReference existingPg = this.getExistingProtectionGroup(parent, name);
            if (existingPg == null) {
                LOGGER.debug("Protection group with ID '{}' and name '{}' does not exist.", (Object)iePg.getId(), (Object)name);
                return Promises.reject((Exception)pgPromiseResult.getError());
            }
            ImpexImportSrmContext.get().addError(ImpexL10N.localize("group.create", name), pgPromiseResult.getError());
            idToMoRef.put(id, existingPg);
            Promise pgPromise = iePg.isProtectedSiteLocal() ? Promises.resolve((Object)existingPg) : this.peerProtectionGroup(existingPg, true).thenApply(ProtectionGroup.Peer::getGroup).onSuccess(res -> LOGGER.debug("Successfully retrieved protection group with ID '{}' and name '{}'.", (Object)iePg.getId(), (Object)name)).onError(err -> LOGGER.warn("Failed to retrieve protection group with ID '{}' and name '{}'.", new Object[]{iePg.getId(), name, err}));
            if (ImpexImportSrmContext.get().getImportConfig().allowOverrideProtectionSettings() && iePg instanceof IeSrmConfigVmProtectionGroup) {
                return pgPromise.thenCompose(pgMoRef -> this._protectedVmUpdater.reconfigureProtectedVmsRls((IeSrmConfigVmProtectionGroup)iePg, (ManagedObjectReference)pgMoRef).thenApply(unused -> pgMoRef));
            }
            return pgPromise;
        }
        return Promises.reject((Exception)pgPromiseResult.getError());
    }

    private Promise<ProtectionGroup.Peer> peerProtectionGroup(ManagedObjectReference pgMoRef, boolean isMoRefLocal) {
        ProtectionGroup pg = (ProtectionGroup)IContextUtil.getSrmService(isMoRefLocal).createStub(pgMoRef);
        FuturePromise peerPromise = new FuturePromise();
        pg.getPeerBasicInfo((Future)peerPromise);
        return peerPromise;
    }

    private ManagedObjectReference getExistingProtectionGroup(ManagedObjectReference parent, String name) {
        ManagedObjectReference[] children;
        if (parent == null || name == null) {
            throw new IllegalArgumentException("Arguments parent, name or both are null.");
        }
        for (ManagedObjectReference child : children = (ManagedObjectReference[])this._basicElementsPcResult.getProperty(parent, "childEntity")) {
            String childName;
            String type = child.getType();
            if (!"DrReplicationVmProtectionGroup".equals(type) || !(childName = (String)this._basicElementsPcResult.getProperty(child, PROTECTION_GROUP.BASIC_SETTINGS_.NAME)).equals(name)) continue;
            return child;
        }
        return null;
    }
}

