/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.plans;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.configurables.mappings.RecoveryTestNetworkMappingConverter;
import com.vmware.srm.client.impex.configurables.plans.CalloutSpecConverter;
import com.vmware.srm.client.impex.configurables.plans.IeCalloutSpec;
import com.vmware.srm.client.impex.configurables.plans.IeRecoveryPlan;
import com.vmware.srm.client.impex.importers.folders.groups.GroupImporter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.recovery.CalloutSpec;
import com.vmware.vim.binding.dr.recovery.RecoveryManager;
import com.vmware.vim.binding.dr.recovery.RecoveryPlan;
import com.vmware.vim.binding.dr.recovery.RecoveryPlanSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanImporter.class);
    private final boolean _local;
    private final InventoryExtractor.InventoryLookup _inventory;
    private final GroupImporter.GroupsLookup _groupsLookup;

    public PlanImporter(boolean local, InventoryExtractor.InventoryLookup inventory, GroupImporter.GroupsLookup groupsLookup) {
        this._local = local;
        this._inventory = inventory;
        this._groupsLookup = groupsLookup;
    }

    public Promise<ManagedObjectReference> create(IeRecoveryPlan ieRecoveryPlan, ManagedObjectReference location) {
        if (ieRecoveryPlan == null) {
            return Promises.reject((Exception)new IllegalArgumentException("IeRecoveryPlan is null."));
        }
        if (location == null) {
            return Promises.reject((Exception)new IllegalArgumentException("Location moRef is null."));
        }
        SrmService service = IContextUtil.getSrmService(this._local);
        RecoveryManager rm = (RecoveryManager)service.createStub(IContextUtil.getSrmContent(this._local).getRecoveryManager());
        RecoveryPlanSpec spec = this.buildRpSpec(ieRecoveryPlan, this._inventory);
        ManagedObjectReference remoteSiteMoRef = this._local ? ImpexImportSrmContext.get().getServersDataWrapper().getLocalPair().pairServerVmomiRef() : ImpexImportSrmContext.get().getServersDataWrapper().getRemotePair().pairServerVmomiRef();
        LOGGER.info("Creating recovery plan '{}' on server with guid '{}'.", (Object)ieRecoveryPlan.getName(), (Object)rm._getRef().getServerGuid());
        FuturePromise taskMoRefPromise = new FuturePromise();
        rm.createRecoveryPlan(location, spec, remoteSiteMoRef, (Future)taskMoRefPromise);
        return taskMoRefPromise.thenCompose(taskMoRef -> ImpexImportSrmContext.get().monitor((ManagedObjectReference)taskMoRef));
    }

    private RecoveryPlanSpec buildRpSpec(IeRecoveryPlan ieRecoveryPlan, InventoryExtractor.InventoryLookup inventory) {
        RecoveryPlanSpec spec = new RecoveryPlanSpec();
        this.setBasicSettings(ieRecoveryPlan, spec);
        this.setNetworkSettings(ieRecoveryPlan, spec, inventory);
        this.setCalloutSpecs(ieRecoveryPlan, spec);
        return spec;
    }

    private void setBasicSettings(IeRecoveryPlan ieRecoveryPlan, RecoveryPlanSpec spec) {
        spec.setName(ieRecoveryPlan.getName());
        spec.setDescription(ieRecoveryPlan.getDescription());
        spec.setGroupsToAdd(this.convertProtectionGroups(ieRecoveryPlan));
    }

    private ManagedObjectReference[] convertProtectionGroups(IeRecoveryPlan ieRecoveryPlan) {
        List<String> ids = ieRecoveryPlan.getProtectionGroups();
        if (CollectionUtils.isEmpty(ids)) {
            LOGGER.debug("No plan protection group ids.");
            return null;
        }
        Object[] protectionGroups = (ManagedObjectReference[])ids.stream().filter(id -> {
            boolean isPresent = this._groupsLookup.containsKey(id);
            if (!isPresent) {
                ImpexImportSrmContext context = ImpexImportSrmContext.get();
                String message = ImpexL10N.localize("plan.addGroup", context.names().getPg((String)id), ieRecoveryPlan.getName());
                LOGGER.warn(message);
                context.addError(message);
            }
            return isPresent;
        }).map(this._groupsLookup::get).toArray(ManagedObjectReference[]::new);
        if (ArrayUtils.isEmpty((Object[])protectionGroups)) {
            LOGGER.debug("No plan protection groups morefs.");
            return null;
        }
        return protectionGroups;
    }

    private void setNetworkSettings(IeRecoveryPlan ieRecoveryPlan, RecoveryPlanSpec spec, InventoryExtractor.InventoryLookup inventory) {
        Object[] networkMappings = RecoveryTestNetworkMappingConverter.toVmodl(ieRecoveryPlan.getNetworks(), inventory);
        Object[] keyedVms = this.convertKeyedVms(ieRecoveryPlan.getKeyedVms(), inventory, ieRecoveryPlan.getName());
        spec.localSettings = new RecoveryPlanSpec.SiteSpec();
        spec.localSettings.mappingsToAdd = networkMappings;
        if (ArrayUtils.isNotEmpty((Object[])keyedVms)) {
            spec.localSettings.setSuspendVmsToAdd((RecoveryPlan.KeyedVm[])keyedVms);
        }
        if (ArrayUtils.isNotEmpty((Object[])networkMappings)) {
            spec.remoteSettings = new RecoveryPlanSpec.SiteSpec();
        }
    }

    private void setCalloutSpecs(IeRecoveryPlan ieRecoveryPlan, RecoveryPlanSpec spec) {
        List<IeCalloutSpec> calloutSpecs = ieRecoveryPlan.getCalloutSpecs();
        if (CollectionUtils.isEmpty(calloutSpecs)) {
            LOGGER.debug("CalloutSpecs are empty, for recovery plan: '{}'.", (Object)ieRecoveryPlan.getName());
            return;
        }
        spec.setCalloutSpecs((CalloutSpec[])calloutSpecs.stream().map(ieCalloutSpec -> CalloutSpecConverter.toVmodl(ieCalloutSpec, ieRecoveryPlan.getName())).toArray(CalloutSpec[]::new));
    }

    private RecoveryPlan.KeyedVm[] convertKeyedVms(List<String> ieKeyedVms, InventoryExtractor.InventoryLookup inventory, String planName) {
        if (CollectionUtils.isEmpty(ieKeyedVms)) {
            LOGGER.debug("IeKeyedVms is empty or null.");
            return null;
        }
        List vms = ieKeyedVms.stream().map(keyedVm -> {
            ManagedObjectReference vmMoRef = (ManagedObjectReference)inventory.get(keyedVm);
            if (Objects.isNull(vmMoRef)) {
                ImpexImportSrmContext context = ImpexImportSrmContext.get();
                String message = ImpexL10N.localize("plan.vm", context.names().getVm((String)keyedVm), planName);
                LOGGER.warn(message);
                context.addError(message);
            }
            return vmMoRef;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (vms.isEmpty()) {
            LOGGER.debug("VM morefs are empty or null.");
            return null;
        }
        RecoveryPlan.KeyedVm[] keyedVms = new RecoveryPlan.KeyedVm[vms.size()];
        for (int i = 0; i < vms.size(); ++i) {
            keyedVms[i] = new RecoveryPlan.KeyedVm(i, (ManagedObjectReference)vms.get(i), null);
        }
        return keyedVms;
    }
}

