/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.vmSettings;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.configurables.InventoryNames;
import com.vmware.srm.client.impex.configurables.vmSettings.IeVmSettings;
import com.vmware.srm.client.impex.configurables.vmSettings.VmSettingsConverter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.impex.utils.PlanUtil;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.recovery.RecoveryPlan;
import com.vmware.vim.binding.dr.recovery.RecoverySettingsRepository;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.recovery.RECOVERY_PLAN;
import com.vmware.vim.vmomi.core.Future;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class VmSettingsImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmSettingsImporter.class);
    private final SrmServer _server;
    private final InventoryExtractor.InventoryLookup _inventory;
    private final RecoverySettingsRepository _repository;

    public VmSettingsImporter(boolean local, InventoryExtractor.InventoryLookup inventory) {
        this._server = IContextUtil.getSrmServer(local);
        this._repository = (RecoverySettingsRepository)((SrmService)this._server.service()).createStub(IContextUtil.getSrmContent((boolean)local).recoverySettingsRepository);
        this._inventory = inventory;
    }

    public Promise<Void> create() {
        List<IeVmSettings> ieVmSettings = ImpexImportSrmContext.get().getConfigurablesWrapper().getVmSettings();
        if (CollectionUtils.isEmpty(ieVmSettings)) {
            LOGGER.warn("No VM settings to import for server with guid '{}'.", (Object)this._server.guid());
            return Promises.resolve(null);
        }
        HashSet<String> alreadyUpdatedKeys = new HashSet<String>();
        int maxAttempts = ImpexImportSrmContext.get().getImportConfig().getRetriesCount();
        Validate.isTrue((maxAttempts >= 1 ? 1 : 0) != 0, (String)"max attempts");
        return this.create(this.removeByGuid(ieVmSettings, this._server.guid()), alreadyUpdatedKeys, maxAttempts).onError(error -> LOGGER.warn("Error while importing VM settings for server with guid '{}'.", (Object)this._server.guid(), error));
    }

    private Promise<Void> create(Set<IeVmSettings> ieVmSettings, Set<String> alreadyUpdatedKeys, int attempts) {
        return this.doCreate(ieVmSettings, alreadyUpdatedKeys).thenCompose(remainingIeVmSettings -> {
            if (remainingIeVmSettings.isEmpty()) {
                return Promises.resolve(null);
            }
            int attemptsLeft = attempts - 1;
            LOGGER.debug("VM settings left for import count: {}, attempts left: {}.", (Object)remainingIeVmSettings.size(), (Object)attemptsLeft);
            if (attemptsLeft <= 0) {
                String message = ImpexL10N.localize("vmSettings.maxAttemptsExceeded", this._server.guid(), this.listVmSettings((Set<IeVmSettings>)remainingIeVmSettings));
                LOGGER.debug(message);
                ImpexImportSrmContext.get().addError(message);
                return Promises.reject((Exception)new RuntimeException("Max attempts exceeded."));
            }
            int delay = ImpexImportSrmContext.get().getImportConfig().getRetriesDelay();
            Validate.isTrue((delay >= 1 ? 1 : 0) != 0, (String)"delay");
            return Promises.createDelayedPromise((long)delay, (Object)remainingIeVmSettings).thenCompose(remaining -> this.create((Set<IeVmSettings>)remaining, alreadyUpdatedKeys, attemptsLeft));
        });
    }

    private Promise<Set<IeVmSettings>> doCreate(Set<IeVmSettings> ieVmSettings, Set<String> alreadyUpdatedKeys) {
        return this.getKeyToSettingMap(ieVmSettings).thenCombineCompose(PlanUtil.getRecoveryPlanStatuses((ServersView)IContextUtil.getSrmView(), this._server.guid()), (keyToVmSetting, statusesPcResult) -> {
            List<ManagedObjectReference> rpMoRefs = PlanUtil.getRecoveryPlanMoRefs(statusesPcResult);
            ArrayList promises = new ArrayList();
            rpMoRefs.forEach(planMoRef -> {
                RecoveryPlan.VmRecoveryStatus[] statuses = (RecoveryPlan.VmRecoveryStatus[])statusesPcResult.getProperty(planMoRef, "vmRecoveryStatus");
                Object[] toUpdate = this.getSettingsToUpdate(statuses, alreadyUpdatedKeys, (Map<String, RecoverySettingsRepository.VmSettingsMapping>)keyToVmSetting, (ManagedObjectReference)planMoRef);
                String recoveryPlanName = (String)statusesPcResult.getProperty(planMoRef, RECOVERY_PLAN.INFO_.NAME);
                if (ArrayUtils.isEmpty((Object[])toUpdate)) {
                    LOGGER.info("No virtual machines in recovery plan '{}'.", (Object)recoveryPlanName);
                    return;
                }
                RecoveryPlan.StateInfo planStateInfo = (RecoveryPlan.StateInfo)statusesPcResult.getProperty(planMoRef, RECOVERY_PLAN.INFO_.STATE_INFO);
                boolean recoverySiteLocal = PlanUtil.isRecoverySiteLocal(planStateInfo.state);
                if (!recoverySiteLocal) {
                    LOGGER.debug("Recovery site is not local for recovery plan '{}'.", planMoRef);
                    return;
                }
                promises.add(this.updateVmSettingMappings((ManagedObjectReference)planMoRef, (RecoverySettingsRepository.VmSettingsMapping[])toUpdate, recoveryPlanName));
            });
            ieVmSettings.removeIf(ieVmSetting -> {
                String uuid = (String)this._inventory.getVmKeysLookup().get(ieVmSetting.getId());
                if (Objects.isNull(uuid)) {
                    LOGGER.warn("VmKeys does not contain IeVmId '{}'.", (Object)ieVmSetting.getId());
                    return true;
                }
                return alreadyUpdatedKeys.contains(uuid);
            });
            if (promises.isEmpty()) {
                LOGGER.debug("No VM setting mappings updated for guid: '{}'.", (Object)this._server.guid());
                return Promises.resolve((Object)ieVmSettings);
            }
            return Promises.allWithException((Promise[])promises.toArray(new Promise[promises.size()])).thenApply(unused -> ieVmSettings);
        });
    }

    private Promise<Map<String, RecoverySettingsRepository.VmSettingsMapping>> getKeyToSettingMap(Set<IeVmSettings> ieVmSettings) {
        FuturePromise mappingsPromise = new FuturePromise();
        this._repository.getRecoverySettings((Future)mappingsPromise);
        return mappingsPromise.thenApply(mappings -> {
            if (mappings == null) {
                return Collections.emptyMap();
            }
            return Arrays.stream(mappings).collect(Collectors.toMap(RecoverySettingsRepository.VmSettingsMapping::getKey, Function.identity()));
        }).thenApply(keyToSetting -> VmSettingsConverter.toVmodl(ieVmSettings, this._inventory.getVmKeysLookup(), keyToSetting));
    }

    private RecoverySettingsRepository.VmSettingsMapping[] getSettingsToUpdate(RecoveryPlan.VmRecoveryStatus[] statuses, Set<String> alreadyUpdatedKeys, Map<String, RecoverySettingsRepository.VmSettingsMapping> keyToVmSetting, ManagedObjectReference planMoRef) {
        return (RecoverySettingsRepository.VmSettingsMapping[])Arrays.stream(statuses).filter(status -> {
            String key = status.getKey();
            if (alreadyUpdatedKeys.contains(key)) {
                return false;
            }
            if (!keyToVmSetting.containsKey(key)) {
                LOGGER.warn("Vm key '{}' not found for plan '{}' with status '{}'.", new Object[]{key, planMoRef, status.status});
                return false;
            }
            alreadyUpdatedKeys.add(key);
            return true;
        }).map(RecoveryPlan.VmRecoveryStatus::getKey).map(keyToVmSetting::get).toArray(RecoverySettingsRepository.VmSettingsMapping[]::new);
    }

    private Promise<ManagedObjectReference> updateVmSettingMappings(ManagedObjectReference recoveryPlan, RecoverySettingsRepository.VmSettingsMapping[] toUpdate, String recoveryPlanName) {
        FuturePromise taskPromise = new FuturePromise();
        this._repository.updatePlanRecoverySettings(recoveryPlan, toUpdate, (Future)taskPromise);
        return taskPromise.thenCompose(taskMoRef -> ImpexImportSrmContext.get().monitor((ManagedObjectReference)taskMoRef)).onSuccess(done -> LOGGER.info("VM recovery settings updated successfully for recovery plan '{}', with moref '{}', on server with guid '{}'.", new Object[]{recoveryPlanName, recoveryPlan, this._repository._getRef().getServerGuid()})).onError(error -> {
            String msg = ImpexL10N.localize("vmSettings.forPlan", recoveryPlanName, recoveryPlan, this._repository._getRef().getServerGuid());
            LOGGER.warn(msg, (Throwable)error);
            ImpexImportSrmContext.get().addError(msg, (Exception)error);
        });
    }

    private Set<IeVmSettings> removeByGuid(List<IeVmSettings> ieVmSettings, String guid) {
        if (CollectionUtils.isEmpty(ieVmSettings)) {
            return Collections.emptySet();
        }
        return ieVmSettings.stream().filter(vmSetting -> this._inventory.containsKey(vmSetting.getId())).filter(vmSetting -> !guid.equals(((ManagedObjectReference)this._inventory.get(vmSetting.getId())).getServerGuid())).collect(Collectors.toSet());
    }

    private String listVmSettings(Set<IeVmSettings> ieVmSettingsLeft) {
        InventoryNames names = ImpexImportSrmContext.get().names();
        return ieVmSettingsLeft.stream().map(IeVmSettings::getId).map(names::getVm).collect(Collectors.joining(", ", "[", "]"));
    }
}

