/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.importers.advancedSettings.SiteAdvancedSettingsImporter;
import com.vmware.srm.client.impex.importers.folders.groups.GroupFolderImporter;
import com.vmware.srm.client.impex.importers.folders.groups.GroupImporter;
import com.vmware.srm.client.impex.importers.folders.groups.vm.RecoveryLocationSettingsConverter;
import com.vmware.srm.client.impex.importers.folders.groups.vm.VmGroupImporter;
import com.vmware.srm.client.impex.importers.folders.plans.PlanFolderImporter;
import com.vmware.srm.client.impex.importers.folders.plans.PlanImporter;
import com.vmware.srm.client.impex.importers.folders.plans.PlanNetworkMappingsUpdater;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.importers.mappings.MappingsImporter;
import com.vmware.srm.client.impex.importers.placeholderDatastores.PlaceholderDatastoresImporter;
import com.vmware.srm.client.impex.importers.vmSettings.VmSettingsImporter;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.GroupUtil;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.MappingUtil;
import com.vmware.srm.client.impex.utils.PlanUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.pbm.SpbmService;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlImporterHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlImporterHelper.class);

    public static Promise<Void> importMappings(InventoryExtractor.InventoryLookup inventory, Profile[] localProfiles, Profile[] remoteProfiles) {
        LOGGER.debug("Importing mappings started.");
        SrmServersDataWrapper serversData = ImpexImportSrmContext.get().getServersDataWrapper();
        Promise localMappingsCreation = new MappingsImporter(inventory, localProfiles, remoteProfiles, true).create().onSuccess(unused -> LOGGER.debug("Importing mappings for server with guid '{}' is complete.", (Object)((SrmServer)serversData.getLocalPair().server()).guid())).onError(error -> LOGGER.warn("Error while importing mappings for server with guid '{}'.", (Object)((SrmServer)serversData.getLocalPair().server()).guid(), error));
        Promise remoteMappingsCreation = new MappingsImporter(inventory, localProfiles, remoteProfiles, false).create().onSuccess(unused -> LOGGER.debug("Importing mappings for server with guid '{}' is complete.", (Object)((SrmServer)serversData.getRemotePair().server()).guid())).onError(error -> LOGGER.warn("Error while importing mappings for server with guid '{}'.", (Object)((SrmServer)serversData.getRemotePair().server()).guid(), error));
        return localMappingsCreation.thenCombine(remoteMappingsCreation, (unused1, unused2) -> null);
    }

    public static Promise<Void> importPlaceholders(InventoryExtractor.InventoryLookup inventory) {
        LOGGER.debug("Importing placeholder datastores started.");
        SrmServersDataWrapper serversData = ImpexImportSrmContext.get().getServersDataWrapper();
        String localGuid = ((SrmServer)serversData.getLocalPair().server()).guid();
        String remoteGuid = ((SrmServer)serversData.getRemotePair().server()).guid();
        Promise localPdsPromise = new PlaceholderDatastoresImporter(inventory).create(true).onSuccess(unused -> LOGGER.debug("Importing placeholder datastores for server with guid '{}' is complete.", (Object)localGuid)).onError(error -> LOGGER.warn("Error while importing placeholder datastores for server with guid '{}'.", (Object)localGuid, error));
        Promise remotePdsPromise = new PlaceholderDatastoresImporter(inventory).create(false).onSuccess(unused -> LOGGER.debug("Importing placeholder datastores for server with guid '{}' is complete.", (Object)remoteGuid)).onError(error -> LOGGER.warn("Error while importing placeholder datastores for server with guid '{}'.", (Object)remoteGuid, error));
        return localPdsPromise.thenCombine(remotePdsPromise, (lUnused, rUnused) -> null);
    }

    public static Promise<Void> importAdvancedSettings() {
        SiteAdvancedSettingsImporter importer = new SiteAdvancedSettingsImporter();
        LOGGER.debug("Importing advanced settings started.");
        return importer.create().onSuccess(unused -> LOGGER.debug("Importing advanced settings is complete.")).onError(error -> LOGGER.warn("Error while importing advanced settings.", (Throwable)error));
    }

    public static Promise<GroupImporter.GroupsLookup> importProtectionGroups(InventoryExtractor.InventoryLookup inventory, DomainInfo[] localDomainInfos, DomainInfo[] remoteDomainInfos) {
        RecoveryLocationSettingsConverter rlsConverter = new RecoveryLocationSettingsConverter(inventory);
        VmGroupImporter vmPgImporter = new VmGroupImporter(inventory, rlsConverter, localDomainInfos, remoteDomainInfos);
        ManagedObjectReference rootFolder = GroupUtil.getRootFolder(IContextUtil.getSrmServer(true).guid());
        LOGGER.debug("Starting import of protection group folders.");
        return GroupUtil.getBasicProtectionGroupInfo((ServersView)IContextUtil.getSrmView(), rootFolder).thenCompose(basicPgResult -> new GroupFolderImporter(rootFolder, (PcResult)basicPgResult, vmPgImporter, rlsConverter, inventory).create()).onSuccess(done -> LOGGER.debug("Importing protection groups is complete.")).onError(error -> LOGGER.warn("Error while importing protection groups.", (Throwable)error));
    }

    public static Promise<Void> importRecoveryPlans(InventoryExtractor.InventoryLookup inventory, GroupImporter.GroupsLookup localGroups) {
        return XmlImporterHelper.importRecoveryPlans(inventory, localGroups, true).thenCombineCompose(GroupUtil.getGroupsPeers(IContextUtil.getSrmView(), localGroups), (unused, peerGroups) -> XmlImporterHelper.importRecoveryPlans(inventory, peerGroups, false));
    }

    private static Promise<Void> importRecoveryPlans(InventoryExtractor.InventoryLookup inventory, GroupImporter.GroupsLookup groupsLookup, boolean local) {
        PlanImporter planImporter = new PlanImporter(local, inventory, groupsLookup);
        String guid = IContextUtil.getSrmServer(local).guid();
        LOGGER.debug("Starting import of recovery plan folders for server with guid: '{}'.", (Object)guid);
        ManagedObjectReference rootFolder = PlanUtil.getRootFolder(guid);
        return PlanUtil.getBasicRecoveryPlans((ServersView)IContextUtil.getSrmView(), rootFolder).thenCompose(basicRpsPcResult -> new PlanFolderImporter(rootFolder, (PcResult)basicRpsPcResult, planImporter, new PlanNetworkMappingsUpdater(local, inventory, (PcResult)basicRpsPcResult), local).create()).onSuccess(done -> LOGGER.debug("Importing recovery plan folders is complete for server with guid: '{}'.", (Object)guid)).onError(error -> LOGGER.warn("Error while importing recovery plan folders for server with guid: '{}'.", (Object)guid, error)).thenApply(unused -> null);
    }

    public static Promise<Profile[]> getProfiles(SpbmService spbmService, String guid) {
        return MappingUtil.getProfiles(spbmService).onSuccess(unused -> LOGGER.debug("Getting profiles for server with guid '{}'.", (Object)guid)).onError(error -> LOGGER.warn("Error while getting profiles for server with guid '{}'.", (Object)guid, error));
    }

    public static Promise<DomainInfo[]> getFaultDomains(boolean local) {
        return GroupUtil.getDomainInfos(local).onSuccess(unused -> LOGGER.debug("Getting fault domains for server with guid '{}'.", (Object)IContextUtil.getSrmServer(local).guid())).onError(error -> LOGGER.warn("Error while getting fault domains for server with guid '{}'.", (Object)IContextUtil.getSrmServer(local).guid(), error));
    }

    public static Promise<Void> createVmSettings(InventoryExtractor.InventoryLookup inventory) {
        LOGGER.debug("Starting import of VM settings.");
        Promise<Void> localImport = XmlImporterHelper.createVmSettings(inventory, true);
        Promise<Void> remoteImport = XmlImporterHelper.createVmSettings(inventory, false);
        return localImport.thenCombine(remoteImport, (localUnused, remoteUnused) -> null);
    }

    private static Promise<Void> createVmSettings(InventoryExtractor.InventoryLookup inventory, boolean local) {
        ImpexImportSrmContext context = ImpexImportSrmContext.get();
        SrmServersDataWrapper serversData = context.getServersDataWrapper();
        String guid = local ? ((SrmServer)serversData.getLocalPair().server()).guid() : ((SrmServer)serversData.getRemotePair().server()).guid();
        LOGGER.debug("Starting import of VM settings for server with guid '{}'.", (Object)guid);
        return new VmSettingsImporter(local, inventory).create().onSuccess(done -> LOGGER.debug("Importing VM settings for server with guid '{}' is complete.", (Object)guid)).onError(error -> LOGGER.warn("Error while importing VM settings for server with guid '{}': '{}'.", (Object)guid, (Object)error.getMessage())).materialize().thenApply(unused -> null);
    }
}

