/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.serialize.impl;

import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.impl.XMLFactories;
import com.vmware.vim.vmomi.core.serialize.XmlObjectOutput;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlObjectOutputStream
extends ObjectOutputStream
implements XmlObjectOutput {
    private Marshaller _marshaller;
    private XMLStreamWriter _writer;
    ByteArrayOutputStream _os;
    OutputStream _out;

    public XmlObjectOutputStream(OutputStream out, Marshaller m) throws IOException, XMLStreamException {
        super(out);
        this._out = out;
        this._marshaller = m;
        XMLOutputFactory outFactory = XMLFactories.getOutputFactory();
        this._os = new ByteArrayOutputStream();
        this._writer = outFactory.createXMLStreamWriter(this._os, "utf-8");
    }

    @Override
    public void marshal(Object o) {
        this._os.reset();
        try {
            this._marshaller.marshal(null, o, this._writer);
            this._writer.flush();
            this.writeInt(this._os.size());
            this._os.writeTo(this);
        }
        catch (MarshallException e) {
            throw new RuntimeException(String.format("Unable to marshal output object %1$s", o), e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(String.format("Unable to marshal output object %1$s", o), e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to marshal output object %1$s", o), e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this._writer.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Unable to close stream writer", e);
        }
    }
}

