/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.marshaller;

import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.soap.XmlOutputHandler;
import com.vmware.vim.vmomi.core.soap.impl.CalendarHelper;
import com.vmware.vim.vmomi.core.soap.impl.XmlStreamWriterOutputHandler;
import com.vmware.vim.vmomi.core.soap.impl.marshaller.FieldHelper;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.Util;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlEnumType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.binary.Base64;

public class MarshallerImpl
implements Marshaller {
    private static final String MOREF_TYPE = "type";
    private static final String MOREF_GUID = "serverGuid";
    private static final String FAULT_ELEMENT = "fault";
    private static final String FAULT_MSG_ELEMENT = "localizedMessage";
    private static final String FAULT_MSG_PROPERTY = "message";
    private static final String SOAP_FAULT_ELEMENT = "soapenv:Fault";
    private static final String SOAP_FAULT_CODE_ELEMENT = "faultcode";
    private static final String SOAP_FAULT_CODE = "ServerFaultCode";
    private static final String SOAP_FAULT_STRING_ELEMENT = "faultstring";
    private static final String SOAP_FAULT_DETAIL_ELEMENT = "detail";
    private static final String DEFAULT_ROOT_TAG = "obj";
    private static final String VERSION_ID_ATTRIBUTE = "versionId";
    private static final Charset US_ASCII_CHARSET = Charset.forName("US-ASCII");
    private final VmodlType LocalizedMethodFaultType;
    private final VmodlVersion _version;
    private final boolean _qsFormat;
    private final VmodlContext _context;
    private final VmodlType _arrayOfMoRefType;
    private final VmodlType _moRefType;

    @Deprecated
    public MarshallerImpl(VmodlVersion version, boolean qsFormat) {
        this(version, VmodlContext.getContext(), qsFormat);
    }

    public MarshallerImpl(VmodlVersion version, VmodlContext context, boolean qsFormat) {
        this._version = version;
        this._context = context;
        this._qsFormat = qsFormat;
        this.LocalizedMethodFaultType = context.getVmodlTypeMap().getVmodlType("LocalizedMethodFault");
        this._arrayOfMoRefType = this._context.getVmodlTypeMap().getVmodlType(ManagedObjectReference[].class);
        this._moRefType = this._context.getVmodlTypeMap().getVmodlType(ManagedObjectReference.class);
    }

    @Override
    public void marshal(VmodlField field, Object object, XMLStreamWriter output) throws MarshallException {
        this.marshal(field, object, output, false);
    }

    @Override
    public void marshal(VmodlField field, Object object, XMLStreamWriter output, boolean strictPublic) throws MarshallException {
        this.marshal(field, object, null, new XmlStreamWriterOutputHandler(output), strictPublic);
    }

    @Override
    public void marshal(VmodlField field, Object object, XmlOutputHandler xmlHandler) throws MarshallException {
        this.marshal(field, object, null, xmlHandler);
    }

    @Override
    public void marshal(VmodlField field, Object object, Collection<String> properties, XmlOutputHandler xmlHandler) throws MarshallException {
        this.marshal(field, object, properties, xmlHandler, false);
    }

    public void marshal(VmodlField field, Object object, Collection<String> properties, XmlOutputHandler xmlHandler, boolean strictPublic) throws MarshallException {
        if (object == null) {
            if (field != null && field.isOptional()) {
                return;
            }
            String message = field == null ? "Missing value for null (by default required) field" : "Missing value for required field " + field.getName();
            throw new MarshallException(message);
        }
        MarshalContext ctx = new MarshalContext(field, object, properties, this._version.getNamespace(), xmlHandler, strictPublic);
        ctx.marshal();
    }

    @Override
    public void marshalSoapFault(Exception fault, String fieldWsdlName, XMLStreamWriter output) throws MarshallException {
        this.marshalSoapFault(fault, fieldWsdlName, new XmlStreamWriterOutputHandler(output));
    }

    @Override
    public void marshalSoapFault(Exception fault, String fieldWsdlName, XmlOutputHandler xmlHandler) throws MarshallException {
        this.marshalSoapFault(fault, fieldWsdlName, xmlHandler, false);
    }

    public void marshalSoapFault(Exception fault, String fieldWsdlName, XmlOutputHandler xmlHandler, boolean strictPublic) throws MarshallException {
        VmodlType faultType = this._context.getVmodlTypeMap().getVmodlType(fault.getClass());
        if (faultType == null || !(faultType instanceof ComplexType)) {
            throw new MarshallException(String.format("Unable to resolve type of fault class %1$s", fault.getClass()));
        }
        FieldHelper.DataObjectWrapperField field = new FieldHelper.DataObjectWrapperField(fieldWsdlName + "Fault", (ComplexType)faultType, this._version);
        MarshalContext ctx = new MarshalContext(field, fault, null, null, xmlHandler, strictPublic);
        ctx.marshalSoapFault(field, fault);
    }

    class MarshalContext {
        private final VmodlField _field;
        private final Object _obj;
        private final XmlOutputHandler _xmlHandler;
        private final Collection<String> _properties;
        private final boolean _strictPublic;
        private String _defaultNamespace;

        public MarshalContext(VmodlField field, Object obj, Collection<String> properties, String defaultNamespace, XmlOutputHandler xmlHandler, boolean strictPublic) {
            this._field = field;
            this._obj = obj;
            this._xmlHandler = xmlHandler;
            this._defaultNamespace = defaultNamespace;
            this._properties = properties;
            this._strictPublic = strictPublic;
        }

        public void marshal() throws MarshallException {
            try {
                VmodlType dynamicType = Util.getVmodlObjectType(this._obj, MarshallerImpl.this._context);
                if (this._field != null) {
                    this.marshalField(this._field, this._field.getName(), dynamicType, this._obj, !dynamicType.equals(this._field.getType()), this._field.getType(), this._properties);
                } else {
                    this.marshalField(null, MarshallerImpl.DEFAULT_ROOT_TAG, dynamicType, this._obj, true, null, this._properties);
                }
                this._xmlHandler.flush();
            }
            catch (XMLStreamException e) {
                throw new MarshallException("Unable to marshal object", e);
            }
        }

        public void marshalSoapFault(VmodlField field, Exception fault) throws MarshallException {
            try {
                this._xmlHandler.writeStartElement(MarshallerImpl.SOAP_FAULT_ELEMENT);
                this._xmlHandler.writeStartElement(MarshallerImpl.SOAP_FAULT_CODE_ELEMENT);
                this._xmlHandler.writeCharacters(MarshallerImpl.SOAP_FAULT_CODE);
                this._xmlHandler.writeEndElement();
                this._xmlHandler.writeStartElement(MarshallerImpl.SOAP_FAULT_STRING_ELEMENT);
                String message = fault.getMessage();
                if (message != null) {
                    this._xmlHandler.writeCharacters(message);
                }
                this._xmlHandler.writeEndElement();
                this._xmlHandler.writeStartElement(MarshallerImpl.SOAP_FAULT_DETAIL_ELEMENT);
                this.marshalField(field, field.getName(), field.getType(), fault, true, null, null);
                this._xmlHandler.writeEndElement();
                this._xmlHandler.writeEndElement();
                this._xmlHandler.flush();
            }
            catch (XMLStreamException e) {
                throw new MarshallException("Unable to marshal object", e);
            }
        }

        public void marshalField(VmodlField field, String fieldName, VmodlType dynamicType, Object obj, boolean emitType, VmodlType staticType, Collection<String> properties) throws XMLStreamException, MarshallException {
            switch (dynamicType.getKind()) {
                case BOOL: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case TYPE_NAME: 
                case METHOD_NAME: 
                case PROPERTY_PATH: {
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    this.marshalString(field, fieldName, obj.toString(), typeName, null, emitType);
                    break;
                }
                case STRING: {
                    if (MarshallerImpl.this._qsFormat && field != null && field.isLink()) {
                        String key = obj.toString();
                        VmodlType linkableType = field.getLinkType();
                        this.marshalURIInQSFormat(fieldName, "#" + this.constructQsLinkId(key, linkableType), emitType);
                        break;
                    }
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    this.marshalString(field, fieldName, obj.toString(), typeName, null, emitType);
                    break;
                }
                case URI: {
                    if (MarshallerImpl.this._qsFormat) {
                        this.marshalURIInQSFormat(fieldName, obj.toString(), emitType);
                        break;
                    }
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    this.marshalString(field, fieldName, obj.toString(), typeName, null, emitType);
                    break;
                }
                case BINARY: {
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    byte[] data2 = ((Binary)obj).asArray();
                    this.marshalString(field, fieldName, new String(Base64.encodeBase64((byte[])data2, (boolean)false), US_ASCII_CHARSET), typeName, null, emitType);
                    break;
                }
                case DATETIME: {
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    String date = CalendarHelper.formatXsdDateTime((Calendar)obj);
                    this.marshalString(field, fieldName, date, typeName, null, emitType);
                    break;
                }
                case ENUM: {
                    String typeName = emitType ? dynamicType.getWsdlName() : null;
                    String enumLabel = ((VmodlEnumType)dynamicType).getEnumLabel((Enum)obj);
                    this.marshalString(field, fieldName, enumLabel, typeName, dynamicType, false);
                    break;
                }
                case ARRAY: {
                    this.marshalArray(field, fieldName, (VmodlArrayType)dynamicType, obj, emitType, staticType);
                    break;
                }
                case DATA_OBJECT: {
                    if (MarshallerImpl.this._qsFormat && field != null && field.isLinkable()) {
                        this.marshalComplexFieldWithId(field, fieldName, (ComplexType)dynamicType, obj, emitType, staticType, properties);
                        break;
                    }
                    this.marshalComplexField(field, fieldName, (ComplexType)dynamicType, obj, emitType, properties);
                    break;
                }
                case FAULT: {
                    this.marshalFault(field, fieldName, (ComplexType)dynamicType, obj, emitType, properties);
                    break;
                }
                case MOREF: {
                    if (MarshallerImpl.this._qsFormat) {
                        this.marshalMoRefInQSFormat(fieldName, obj, emitType);
                        break;
                    }
                    this.marshalMoRef(field, fieldName, dynamicType, obj, emitType);
                    break;
                }
                case MANAGED_OBJECT: {
                    ManagedObject mo = (ManagedObject)obj;
                    this.marshalMoRef(field, fieldName, MarshallerImpl.this._moRefType, mo._getRef(), emitType);
                    break;
                }
                case ANY: {
                    throw new MarshallException(obj.toString() + " invalid instance. Unexpected type ANY.");
                }
            }
        }

        private void marshalFault(VmodlField field, String fieldName, ComplexType faultType, Object obj, boolean emitType, Collection<String> properties) throws XMLStreamException, MarshallException {
            String typeName = emitType ? "LocalizedMethodFault" : null;
            ComplexType type = emitType ? MarshallerImpl.this.LocalizedMethodFaultType : faultType;
            this.emitStartTag(field, fieldName, typeName, type);
            VmodlField versionedField = this.buildFieldForVersion(MarshallerImpl.this.LocalizedMethodFaultType.getVersion());
            this.marshalComplexField(versionedField, MarshallerImpl.FAULT_ELEMENT, faultType, obj, true, properties);
            if (properties == null || properties.contains(MarshallerImpl.FAULT_MSG_PROPERTY)) {
                this.marshalString(versionedField, MarshallerImpl.FAULT_MSG_ELEMENT, ((Exception)obj).getMessage(), null, null, emitType);
            }
            this.emitEndTag();
        }

        private void marshalURIInQSFormat(String tag, String uri, boolean emitType) throws MarshallException {
            this.emitStartTag(tag, null, null);
            if (emitType) {
                this._xmlHandler.writeNamespace("qs", "urn:vmware:queryservice");
                this._xmlHandler.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", MarshallerImpl.MOREF_TYPE, "qs:Link");
            }
            this._xmlHandler.writeAttribute("xlink", "http://www.w3.org/1999/xlink", "href", uri);
            this.emitEndTag();
        }

        private void validateMoRef(ManagedObjectReference moref) throws MarshallException {
            if (moref == null) {
                throw new MarshallException("Managed object reference is null");
            }
            if (moref.getType() == null) {
                throw new MarshallException("Missing type for managed object reference");
            }
            if (moref.getValue() == null) {
                throw new MarshallException("Missing value for managed object reference");
            }
        }

        private void marshalMoRefInQSFormat(String fieldName, Object obj, boolean emitType) throws MarshallException {
            ManagedObjectReference moref = (ManagedObjectReference)obj;
            this.emitStartTag(fieldName, null, null);
            if (emitType) {
                this._xmlHandler.writeNamespace("qs", "urn:vmware:queryservice");
                this._xmlHandler.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", MarshallerImpl.MOREF_TYPE, "qs:ManagedObjectLink");
            }
            String uri = String.format("urn:vmomi:%s:%s:%s", moref.getType(), moref.getValue(), moref.getServerGuid());
            this._xmlHandler.writeAttribute("xlink", "http://www.w3.org/1999/xlink", "href", uri);
            this.emitEndTag();
        }

        private void marshalMoRef(VmodlField field, String fieldName, VmodlType type, Object obj, boolean emitType) throws MarshallException {
            ManagedObjectReference moref = (ManagedObjectReference)obj;
            this.validateMoRef(moref);
            this.emitStartTag(field, fieldName, emitType ? type.getWsdlName() : null, type);
            this._xmlHandler.writeAttribute(MarshallerImpl.MOREF_TYPE, moref.getType());
            if (moref.getServerGuid() != null && MarshallerImpl.this._version.isInternal()) {
                this._xmlHandler.writeAttribute(MarshallerImpl.MOREF_GUID, moref.getServerGuid());
            }
            this._xmlHandler.writeCharacters(moref.getValue());
            this.emitEndTag();
        }

        private void marshalArray(VmodlField field, String fieldName, VmodlArrayType dynamicType, Object obj, boolean emitType, VmodlType staticType) throws MarshallException, XMLStreamException {
            VmodlType itemType = dynamicType.getComponentType();
            String elementTagName = fieldName;
            if (staticType != null && !staticType.getKind().equals((Object)VmodlType.Kind.ANY) && !staticType.equals(dynamicType)) {
                throw new MarshallException(String.format("Dynamic (%1$s) and declared (%2$s) types do not match and declared type is not ANY (is %3$s)", new Object[]{dynamicType.getWsdlName(), staticType.getWsdlName(), staticType.getKind()}));
            }
            if (Array.getLength(obj) == 0 && (field == null || VmodlType.Kind.ARRAY == field.getType().getKind() && !field.isOptional())) {
                throw new MarshallException("Empty array detected for required array field " + fieldName);
            }
            if (emitType) {
                if (itemType.getKind() == VmodlType.Kind.MANAGED_OBJECT) {
                    elementTagName = MarshallerImpl.this._moRefType.getWsdlName();
                    this.emitStartTag(field, fieldName, MarshallerImpl.this._arrayOfMoRefType.getWsdlName(), dynamicType);
                } else {
                    elementTagName = itemType.getWsdlName();
                    this.emitStartTag(field, fieldName, dynamicType.getWsdlName(), dynamicType);
                    field = this.buildFieldForVersion(itemType.getVersion());
                }
            }
            if (obj instanceof byte[]) {
                for (byte o : (byte[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null, null, false);
                }
            } else if (obj instanceof short[]) {
                for (short o : (short[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null, null, false);
                }
            } else if (obj instanceof int[]) {
                for (int o : (int[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null, null, false);
                }
            } else if (obj instanceof long[]) {
                for (long o : (long[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null, null, false);
                }
            } else if (obj instanceof float[]) {
                for (float o : (float[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null, null, false);
                }
            } else if (obj instanceof double[]) {
                for (double o : (double[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null, null, false);
                }
            } else if (obj instanceof boolean[]) {
                for (boolean o : (boolean[])obj) {
                    this.marshalString(field, elementTagName, String.valueOf(o), null, null, false);
                }
            } else {
                Object[] array = (Object[])obj;
                for (int i = 0; i < array.length; ++i) {
                    VmodlType dynamicItemType;
                    Object o = array[i];
                    if (o == null) {
                        throw new MarshallException("Invalid value for field \"" + fieldName + "\": array contains null at index " + i);
                    }
                    this.marshalField(field, elementTagName, dynamicItemType, o, !(dynamicItemType = Util.getVmodlObjectType(o, MarshallerImpl.this._context)).equals(itemType), staticType != null && !staticType.getKind().equals((Object)VmodlType.Kind.ANY) ? ((VmodlArrayType)staticType).getComponentType() : null, null);
                }
            }
            if (emitType) {
                this.emitEndTag();
            }
        }

        private VmodlField buildFieldForVersion(VmodlVersion version) {
            VmodlFieldImpl field = new VmodlFieldImpl(MarshallerImpl.this._context);
            field.setVersion(version);
            return field;
        }

        private ComplexType getCompatibleType(ComplexType type) {
            while (type != null && (!type.IsVisible(MarshallerImpl.this._version) || this._strictPublic && type.isInternal() && !MarshallerImpl.this._version.isInternal())) {
                type = type.getBaseType();
            }
            return type;
        }

        private void marshalComplexFieldWithId(VmodlField field, String fieldName, ComplexType dynamicType, Object obj, boolean emitType, VmodlType staticType, Collection<String> properties) throws XMLStreamException, MarshallException {
            ComplexTypeField keyField = dynamicType.getProperty("key");
            if (keyField == null || keyField.getType().getKind() != VmodlType.Kind.STRING && keyField.getType().getKind() != VmodlType.Kind.INT) {
                this.marshalComplexField(field, fieldName, dynamicType, obj, emitType, properties);
                return;
            }
            String key = keyField.get(obj).toString();
            if (key == null) {
                this.marshalComplexField(field, fieldName, dynamicType, obj, emitType, properties);
                return;
            }
            ComplexType origType = dynamicType;
            if ((dynamicType = this.getCompatibleType(dynamicType)) == null) {
                throw new MarshallException(String.format("Unable to obtain compatible type for '%1$s'", origType));
            }
            String typeName = emitType ? dynamicType.getWsdlName() : null;
            this.emitStartTag(fieldName, typeName, dynamicType);
            this._xmlHandler.writeAttribute("qs", "urn:vmware:queryservice", "id", this.constructQsLinkId(key, staticType));
            this.marshalSubFields(dynamicType, obj, properties);
            this.emitEndTag();
        }

        private void marshalComplexField(VmodlField field, String fieldName, ComplexType dynamicType, Object obj, boolean emitType, Collection<String> properties) throws XMLStreamException, MarshallException {
            ComplexType origType = dynamicType;
            if ((dynamicType = this.getCompatibleType(dynamicType)) == null) {
                throw new MarshallException(String.format("Unable to obtain compatible type for '%1$s'", origType));
            }
            String typeName = emitType ? dynamicType.getWsdlName() : null;
            this.emitStartTag(field, fieldName, typeName, dynamicType);
            this.marshalSubFields(dynamicType, obj, properties);
            this.emitEndTag();
        }

        private void marshalSubFields(ComplexType dynamicType, Object obj, Collection<String> properties) throws XMLStreamException, MarshallException {
            for (ComplexTypeField field : dynamicType.getProperties()) {
                if (properties != null && !properties.contains(field.getName()) || !field.isVisible(MarshallerImpl.this._version)) continue;
                Object value = field.get(obj);
                if (value == null) {
                    if (field.isOptional()) continue;
                    throw new MarshallException(String.format("%1$s required property %2$s not set", dynamicType.getWsdlName(), field.getName()));
                }
                VmodlType staticFieldType = field.getType();
                VmodlType dynamicTypeField = Util.getVmodlObjectType(value, MarshallerImpl.this._context);
                this.marshalField(field, field.getName(), dynamicTypeField, value, !staticFieldType.equals(dynamicTypeField), staticFieldType, null);
            }
        }

        private void marshalString(VmodlField field, String tag, String value, String typeName, VmodlType type, boolean xsdPrefix) throws MarshallException {
            if (value == null) {
                return;
            }
            if (xsdPrefix && typeName != null) {
                typeName = "xsd:" + typeName;
            }
            this.emitStartTag(field, tag, typeName, type);
            this._xmlHandler.writeCharacters(value);
            this.emitEndTag();
        }

        private void emitStartTag(String tag, String typeName, VmodlType type) throws MarshallException {
            this.emitStartTag(null, tag, typeName, type);
        }

        private void emitStartTag(VmodlField field, String tag, String typeName, VmodlType type) throws MarshallException {
            boolean emitDefaultNamespace = false;
            String effectiveNamespacePrefix = "";
            String effectiveNamespace = null;
            String typeNamespace = "";
            if (MarshallerImpl.this._version.shouldMarshallNamespace()) {
                if (this._defaultNamespace == null) {
                    effectiveNamespace = this._defaultNamespace = this.resolveNamespace(field, type);
                    emitDefaultNamespace = true;
                } else {
                    String startTagNamespace = this.resolveNamespace(field, type);
                    effectiveNamespace = this.getNonDefaultNamespace(startTagNamespace);
                    effectiveNamespacePrefix = this.buildNamespacePrefixWithColon(effectiveNamespace);
                }
                if (typeName != null && type != null) {
                    typeNamespace = this.resolveNamespace(null, type);
                }
            } else if (this._defaultNamespace == null) {
                this._defaultNamespace = MarshallerImpl.this._version.getNamespace();
                emitDefaultNamespace = true;
            }
            this._xmlHandler.writeStartElement(effectiveNamespacePrefix + tag);
            if (typeName != null) {
                this.emitXsiType(typeName, typeNamespace);
            }
            if (emitDefaultNamespace) {
                this._xmlHandler.writeAttribute("xmlns", "urn:" + this._defaultNamespace);
            }
            if (field instanceof FieldHelper.RootField) {
                if (!emitDefaultNamespace) {
                    this._xmlHandler.writeAttribute("xmlns", "urn:" + this._defaultNamespace);
                }
                if (field.getVersion() != null && field.getVersion().getVersionId() != null && !field.getVersion().getVersionId().isEmpty()) {
                    this._xmlHandler.writeAttribute(MarshallerImpl.VERSION_ID_ATTRIBUTE, field.getVersion().getVersionId());
                }
                if (field instanceof FieldHelper.QsRootField && ((FieldHelper.QsRootField)field).getQSId() != null && !((FieldHelper.QsRootField)field).getQSId().isEmpty()) {
                    this._xmlHandler.writeAttribute("qs", "urn:vmware:queryservice", "id", ((FieldHelper.QsRootField)field).getQSId());
                }
            }
            this.emitNamespaceDeclarations(effectiveNamespace, typeNamespace);
        }

        private void emitNamespaceDeclarations(String ... namespaces) throws MarshallException {
            if (namespaces == null) {
                return;
            }
            for (String namesp : namespaces) {
                if (namesp == null || "".equals(namesp)) continue;
                this._xmlHandler.writeNamespace(namesp, "urn:" + namesp);
            }
        }

        private void emitXsiType(String typeName, String typeNamespace) throws MarshallException {
            String typePrefix = typeNamespace;
            if (!"".equals(typePrefix)) {
                typePrefix = typePrefix + ":";
            }
            if (typeName != null) {
                this._xmlHandler.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", MarshallerImpl.MOREF_TYPE, typePrefix + typeName);
            }
        }

        private void emitEndTag() throws MarshallException {
            this._xmlHandler.writeEndElement();
        }

        private String constructQsLinkId(String key, VmodlType staticType) throws MarshallException {
            String encodedKey;
            try {
                encodedKey = URLEncoder.encode(key, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new MarshallException(String.format("Unable to encode '%1$s'", key));
            }
            return String.format("%1$s:%2$s", staticType.getWsdlName(), encodedKey);
        }

        private String resolveNamespace(VmodlField field, VmodlType type) {
            String namespace;
            if (field != null) {
                namespace = field.getVersion().getService().getServiceNamespace();
            } else if (type != null) {
                namespace = type.getVersion().getService().getServiceNamespace();
            } else {
                return "";
            }
            if (MarshallerImpl.this._version.isInternal()) {
                namespace = "internal" + namespace;
            }
            return namespace;
        }

        private String getNonDefaultNamespace(String namespace) {
            return this._defaultNamespace.equals(namespace) ? "" : namespace;
        }

        private String buildNamespacePrefixWithColon(String namespace) {
            return "".equals(namespace) ? "" : namespace + ":";
        }
    }
}

