/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.tracing;

import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlobalTracer {
    private static Log _logger = LogFactory.getLog(GlobalTracer.class);

    private GlobalTracer() {
    }

    public static Tracer get() {
        if (!io.opentracing.util.GlobalTracer.isRegistered()) {
            String serviceName = GlobalTracer.getServiceName();
            String host = GlobalTracer.getJaegerHost();
            Configuration config = new Configuration(serviceName);
            config.withSampler(Configuration.SamplerConfiguration.fromEnv().withType("const").withParam((Number)1)).withReporter(Configuration.ReporterConfiguration.fromEnv().withSender(Configuration.SenderConfiguration.fromEnv().withAgentHost(host)));
            io.opentracing.util.GlobalTracer.registerIfAbsent((Tracer)config.getTracer());
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)String.format("Jaeger client initialized - serviceName: '%1$s', host: '%2$s'", serviceName, host));
            }
        }
        return io.opentracing.util.GlobalTracer.get();
    }

    private static String getServiceName() {
        String serviceName = GlobalTracer.getServiceNameFromSystemProperty();
        if (serviceName != null) {
            return serviceName;
        }
        serviceName = GlobalTracer.getServiceNameFromEnvironment();
        if (serviceName != null) {
            return serviceName;
        }
        serviceName = GlobalTracer.getServiceNameFromGCLogFolderName();
        if (serviceName != null) {
            return serviceName;
        }
        return "unknown";
    }

    private static String getServiceNameFromSystemProperty() {
        try {
            return System.getProperty("tracing.serviceName");
        }
        catch (SecurityException e) {
            _logger.debug((Object)"Unable to read tracing.serviceName system property", (Throwable)e);
            return null;
        }
    }

    private static String getServiceNameFromEnvironment() {
        return System.getenv("JAEGER_SERVICE_NAME");
    }

    private static String getServiceNameFromGCLogFolderName() {
        List<String> listOfArguments;
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        try {
            listOfArguments = runtimeMxBean.getInputArguments();
        }
        catch (SecurityException e) {
            _logger.debug((Object)"Unable to read command line arguments", (Throwable)e);
            return null;
        }
        for (String arg : listOfArguments) {
            String[] folders;
            if (!arg.startsWith("-Xloggc:") || (folders = arg.split("/")).length <= 2) continue;
            return folders[folders.length - 2];
        }
        return null;
    }

    private static String getJaegerHost() {
        String host = System.getenv("JAEGER_AGENT_HOST");
        return host == null ? "localhost" : host;
    }
}

