/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.compatible;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.service;
import com.vmware.vim.binding.vmodl.versionId;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmomiService;
import com.vmware.vim.vmomi.core.types.impl.VmomiServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VmodlVersionImpl
implements VmodlVersion {
    public static final String INTERNAL_PREFIX = "internal";
    static final ConcurrentMap<Class<?>, VmodlVersionImpl> registry = new ConcurrentHashMap();
    private final Class<?> _versionClass;
    private final Set<VmodlVersion> _parent;
    private final String _versionId;
    private final boolean _internal;
    private final VmomiService _service;
    private final String _wsdlNamespace;
    private final String _namespace;
    private final boolean _shouldMarshallNamespace;
    private Set<VmodlVersion> _compatible;

    private VmodlVersionImpl(Class<?> version) {
        this._versionClass = version;
        this._parent = this.getParentVersions();
        versionId versionIdAnnotation = this._versionClass.getAnnotation(versionId.class);
        this._versionId = versionIdAnnotation == null ? null : versionIdAnnotation.value();
        this._internal = this._versionClass.getAnnotation(internal.class) != null;
        service serviceAnnotation = this._versionClass.getAnnotation(service.class);
        this._service = serviceAnnotation != null ? new VmomiServiceImpl(serviceAnnotation) : VmomiServiceImpl.DEFAULT_SERVICE;
        wsdlName nsAnnotation = this._versionClass.getAnnotation(wsdlName.class);
        if (nsAnnotation != null) {
            this._namespace = this._wsdlNamespace = nsAnnotation.value();
        } else {
            this._wsdlNamespace = null;
            this._namespace = this._internal ? INTERNAL_PREFIX + this._service.getServiceNamespace() : this._service.getServiceNamespace();
        }
        this._shouldMarshallNamespace = this.computeShouldMarshallNamespace();
    }

    public static VmodlVersionImpl getOrRegister(Class<?> clazz) {
        VmodlVersionImpl newVersion;
        VmodlVersionImpl v = (VmodlVersionImpl)registry.get(clazz);
        if (v == null && (v = registry.putIfAbsent(clazz, newVersion = new VmodlVersionImpl(clazz))) == null) {
            v = newVersion;
        }
        return v;
    }

    private Set<VmodlVersion> getParentVersions() {
        compatible compatAnnotation = this._versionClass.getAnnotation(compatible.class);
        if (compatAnnotation == null) {
            return Collections.emptySet();
        }
        Class[] compatibleClasses = compatAnnotation.value();
        if (compatibleClasses.length == 0) {
            return Collections.emptySet();
        }
        VmodlVersion[] versions = new VmodlVersion[compatibleClasses.length];
        for (int i = 0; i < compatibleClasses.length; ++i) {
            versions[i] = VmodlVersionImpl.getOrRegister(compatibleClasses[i]);
        }
        return new LooseReadOnlySet<VmodlVersion>(Arrays.asList(versions));
    }

    boolean computeShouldMarshallNamespace() {
        if ("".equals(this._service.getServiceNamespace())) {
            return false;
        }
        if (this._internal) {
            String internalPrefixed = INTERNAL_PREFIX + this._service.getServiceNamespace();
            return internalPrefixed.equals(this._namespace);
        }
        return this._service.getServiceNamespace().equals(this._namespace);
    }

    @Override
    public String getVersionId() {
        return this._versionId;
    }

    @Override
    public String getWsdlNamespace() {
        return this._wsdlNamespace;
    }

    @Override
    public boolean isCompatible(VmodlVersion version) {
        if (this._compatible == null) {
            HashSet<VmodlVersion> compatible2 = new HashSet<VmodlVersion>();
            this.resolveDependency(this, compatible2);
            this._compatible = compatible2;
        }
        return this._compatible.contains(version);
    }

    private void resolveDependency(VmodlVersion version, Set<VmodlVersion> compatible2) {
        compatible2.add(version);
        Set<VmodlVersion> parent = version.getParentVersion();
        Iterator<VmodlVersion> it = parent.iterator();
        while (it.hasNext()) {
            this.resolveDependency(it.next(), compatible2);
        }
    }

    @Override
    public Set<VmodlVersion> getParentVersion() {
        return Collections.unmodifiableSet(this._parent);
    }

    @Override
    public boolean isInternal() {
        return this._internal;
    }

    @Override
    public Class<?> getVersionClass() {
        return this._versionClass;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof VmodlVersion)) {
            return false;
        }
        return this._versionClass.equals(((VmodlVersion)rhs).getVersionClass());
    }

    public int hashCode() {
        return this._versionClass.hashCode();
    }

    public String toString() {
        return String.format("%1$s/%2$s", this.getWsdlNamespace(), this.getVersionId());
    }

    @Override
    public VmomiService getService() {
        return this._service;
    }

    @Override
    public String getNamespace() {
        return this._namespace;
    }

    @Override
    public boolean shouldMarshallNamespace() {
        return this._shouldMarshallNamespace;
    }

    private class LooseReadOnlySet<E>
    implements Set<E> {
        private final Collection<? extends E> c;

        LooseReadOnlySet(Collection<? extends E> c) {
            this.c = c;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = LooseReadOnlySet.this.c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> elements) {
            return this.c.containsAll(elements);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection collection = (Collection)o;
            if (collection.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(collection);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (E e : this) {
                if (e == null) continue;
                h += e.hashCode();
            }
            return h;
        }
    }
}

