/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class X509CertificateUtil {
    public static final String PEM_CERT_HEADER = "-----BEGIN CERTIFICATE-----";
    public static final String PEM_CERT_FOOTER = "-----END CERTIFICATE-----";

    public static X509Certificate parsePemEncodedCertificate(String pemEncodedCert) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is = new ByteArrayInputStream(pemEncodedCert.getBytes(StandardCharsets.UTF_8));
        return (X509Certificate)cf.generateCertificate(is);
    }

    public static String computeThumbprint(X509Certificate cert, String digestAlg) throws NoSuchAlgorithmException, CertificateEncodingException {
        return SslUtil.computeCertificateThumbprint(cert, digestAlg, true);
    }
}

