/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive.impl;

import com.vmware.dr.ui.tools.reactive.Dispatcher;
import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.Subscription;
import com.vmware.dr.ui.tools.reactive.impl.AsyncDispatcherImpl;
import com.vmware.dr.ui.tools.reactive.impl.SubscriberWrapper;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromiseImpl<T>
implements Promise<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PromiseImpl.class);
    private static final ThreadLocal<Map<PromiseImpl<?>, RootCompletion<?>>> ROOTS = ThreadLocal.withInitial(WeakHashMap::new);
    private final AtomicReference<Result<T>> _resultRef = new AtomicReference<Object>(null);
    private final AtomicReference<RootCompletion<T>> _rootsHeadRef = new AtomicReference<Object>(null);

    private static void removeCompletedEntries(boolean removeRoots) {
        Map<PromiseImpl<?>, RootCompletion<?>> roots = ROOTS.get();
        if (roots.keySet().removeIf(PromiseImpl::isComplete) && roots.isEmpty() && removeRoots) {
            ROOTS.remove();
        }
    }

    private RootCompletion<T> getCompletion() {
        PromiseImpl.removeCompletedEntries(false);
        Map<PromiseImpl<?>, RootCompletion<?>> roots = ROOTS.get();
        return roots.computeIfAbsent(this, PromiseImpl::pushOrSetResult);
    }

    @Override
    public Promise<T> onSuccess(Consumer<T> resultConsumer) {
        RootCompletion<T> rc = this.getCompletion();
        return rc.onSuccess(this, resultConsumer);
    }

    @Override
    public Promise<T> onError(Consumer<Exception> errorConsumer) {
        RootCompletion<T> rc = this.getCompletion();
        return rc.onError(this, errorConsumer);
    }

    @Override
    public <U> Promise<U> thenCompose(Function<? super T, ? extends Promise<? extends U>> fn) {
        RootCompletion<? super T> rc = this.getCompletion();
        return rc.thenCompose(this, fn);
    }

    @Override
    public <U> Promise<U> thenApply(Function<? super T, ? extends U> fn) {
        RootCompletion<? super T> rc = this.getCompletion();
        return rc.thenApply(this, fn);
    }

    @Override
    public <U, V> Promise<V> thenCombine(Promise<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        RootCompletion<? super T> rc = this.getCompletion();
        return rc.thenCombine(this, other, fn);
    }

    @Override
    public <U, V> Promise<V> thenCombineCompose(Promise<? extends U> other, BiFunction<? super T, ? super U, ? extends Promise<? extends V>> fn) {
        RootCompletion<? super T> rc = this.getCompletion();
        return rc.thenCombineCompose(this, other, fn);
    }

    @Override
    public Promise<PromiseResult<T>> materialize() {
        RootCompletion<T> rc = this.getCompletion();
        return rc.materialize(this);
    }

    @Override
    public Subscription<T> subscribe(Subscriber<? super T> subscriber) {
        RootCompletion<? super T> rc = this.getCompletion();
        return rc.subscribe(this, subscriber);
    }

    public boolean setResult(T value) {
        try {
            boolean bl = this.complete(new Result<T>(value));
            return bl;
        }
        finally {
            PromiseImpl.removeCompletedEntries(true);
        }
    }

    public boolean setError(Exception err) {
        try {
            boolean bl = this.complete(new Result(err));
            return bl;
        }
        finally {
            PromiseImpl.removeCompletedEntries(true);
        }
    }

    public boolean isComplete() {
        return this._resultRef.get() != null;
    }

    RootCompletion<T> pushOrSetResult() {
        boolean onList;
        RootCompletion<T> rc = new RootCompletion<T>(this._rootsHeadRef.get());
        Result<T> result = null;
        while (!(onList = this._rootsHeadRef.compareAndSet(((RootCompletion)rc)._next, rc)) && (result = this._resultRef.get()) == null) {
            rc = new RootCompletion<T>(this._rootsHeadRef.get());
        }
        if (result != null || (result = this._resultRef.get()) != null) {
            if (onList) {
                this.notifyRoots(result);
            } else {
                rc.complete(result);
            }
        }
        return rc;
    }

    private boolean complete(Result<T> result) {
        if (!this._resultRef.compareAndSet(null, result)) {
            return false;
        }
        this.notifyRoots(result);
        return true;
    }

    private void notifyRoots(Result<T> result) {
        RootCompletion rc = this._rootsHeadRef.getAndSet(null);
        while (rc != null) {
            rc.complete(result);
            rc = rc._next;
        }
    }

    static final class RootCompletion<T> {
        private final RootCompletion<T> _next;
        private final Dispatcher _dispatcher = new AsyncDispatcherImpl();
        private final AtomicReference<Completion<T, ?>> _headRef = new AtomicReference<Object>(null);

        RootCompletion(RootCompletion<T> next) {
            this._next = next;
        }

        public Subscription<T> subscribe(final PromiseImpl<T> promise, final Subscriber<? super T> subscriber) {
            final SubscriberCompletion<? super T> sc = new SubscriberCompletion<T>(subscriber, this._dispatcher, this._headRef.get());
            this.pushOrSetResult(promise, sc);
            return new Subscription<T>(){

                @Override
                public void cancel() {
                    sc.cancel();
                }

                @Override
                public Publisher<T> getPublisher() {
                    return promise;
                }

                @Override
                public Subscriber<? super T> getSubscriber() {
                    return subscriber;
                }
            };
        }

        public Promise<T> onSuccess(PromiseImpl<T> promise, Consumer<T> resultConsumer) {
            SuccessCompletion<T> c = new SuccessCompletion<T>(resultConsumer, this._dispatcher, this._headRef.get());
            this.pushOrSetResult(promise, c);
            return ((Completion)c).getResultPromise();
        }

        public Promise<T> onError(PromiseImpl<T> promise, Consumer<Exception> errorConsumer) {
            ErrorCompletion<T> c = new ErrorCompletion<T>(errorConsumer, this._dispatcher, this._headRef.get());
            this.pushOrSetResult(promise, c);
            return ((Completion)c).getResultPromise();
        }

        public <U> Promise<U> thenCompose(PromiseImpl<T> promise, Function<? super T, ? extends Promise<? extends U>> fn) {
            ComposeCompletion c = new ComposeCompletion(fn, this._dispatcher, this._headRef.get());
            this.pushOrSetResult(promise, c);
            return ((Completion)c).getResultPromise();
        }

        public <U> Promise<U> thenApply(PromiseImpl<T> promise, Function<? super T, ? extends U> fn) {
            ApplyCompletion<T, U> c = new ApplyCompletion<T, U>(fn, this._dispatcher, this._headRef.get());
            this.pushOrSetResult(promise, c);
            return ((Completion)c).getResultPromise();
        }

        public <U, V> Promise<V> thenCombine(PromiseImpl<T> promise, Promise<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
            CombineCompletion<T, U, V> cc = new CombineCompletion<T, U, V>(other, fn, this._dispatcher, this._headRef.get());
            cc.init();
            this.pushOrSetResult(promise, cc);
            return cc.getResultPromise();
        }

        public <U, V> Promise<V> thenCombineCompose(PromiseImpl<T> promise, Promise<? extends U> other, BiFunction<? super T, ? super U, ? extends Promise<? extends V>> fn) {
            CombineCompletion<T, U, Promise<V>> cc = new CombineCompletion<T, U, Promise<V>>(other, fn, this._dispatcher, this._headRef.get());
            cc.init();
            this.pushOrSetResult(promise, cc);
            return cc.getResultPromise().thenCompose(Function.identity());
        }

        public Promise<PromiseResult<T>> materialize(PromiseImpl<T> promise) {
            MaterializeCompletion<T> c = new MaterializeCompletion<T>(this._dispatcher, this._headRef.get());
            this.pushOrSetResult(promise, c);
            return ((Completion)c).getResultPromise();
        }

        void pushOrSetResult(PromiseImpl<T> promise, Completion<T, ?> next) {
            this._headRef.set(next);
            Result result = (Result)((PromiseImpl)promise)._resultRef.get();
            if (result != null) {
                this.complete(result);
                Map roots = (Map)ROOTS.get();
                roots.remove(promise);
                if (roots.isEmpty()) {
                    ROOTS.remove();
                }
            }
        }

        void complete(Result<T> result) {
            Completion head = this._headRef.getAndSet(null);
            while (head != null && head.setResult(result)) {
                head = head._next;
            }
        }
    }

    private static class MaterializeCompletion<R>
    extends Completion<R, PromiseResult<R>> {
        private final PromiseImpl<PromiseResult<R>> _resultPromise = new PromiseImpl();

        MaterializeCompletion(Dispatcher dispatcher, Completion<R, ?> next) {
            super(dispatcher, next);
        }

        @Override
        Promise<PromiseResult<R>> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            this._resultPromise.setResult(PromiseResult.fromResult(value));
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setResult(PromiseResult.fromException(err));
        }
    }

    private static class CombineCompletion<R, U, V>
    extends Completion<R, V>
    implements Subscriber<U> {
        private final Promise<U> _other;
        private final BiFunction<? super R, ? super U, ? extends V> _fn;
        private final PromiseImpl<V> _resultPromise = new PromiseImpl();
        private volatile Subscription<U> _subscription;
        private volatile Result<R> _result1;
        private volatile Result<U> _result2;
        private final AtomicBoolean _complete = new AtomicBoolean(false);

        CombineCompletion(Promise<? extends U> other, BiFunction<? super R, ? super U, ? extends V> fn, Dispatcher dispatcher, Completion<R, ?> next) {
            super(dispatcher, next);
            Validate.notNull(other, (String)"other");
            Validate.notNull(fn, (String)"fn");
            this._other = other;
            this._fn = fn;
        }

        void init() {
            this._subscription = this._other.subscribe(this);
        }

        @Override
        public void onNext(U item) {
            this._result2 = new Result<U>(item);
            if (this._result1 != null && this._complete.compareAndSet(false, true)) {
                this.doComplete(this._result1.value, this._result2.value);
            }
        }

        @Override
        public void onComplete(boolean cancelled) {
        }

        @Override
        public void onError(Exception err) {
            this._resultPromise.setError(err);
        }

        @Override
        Promise<V> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            this._result1 = new Result<R>(value);
            if (this._result2 != null && this._complete.compareAndSet(false, true)) {
                this.doComplete(this._result1.value, this._result2.value);
            }
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setError(err);
            this._subscription.cancel();
        }

        private void doComplete(R result1, U result2) {
            V result;
            try {
                result = this._fn.apply(result1, result2);
            }
            catch (Throwable t) {
                LOGGER.warn("Function '{}' failed.", this._fn, (Object)t);
                this._resultPromise.setError(Exceptions.wrap(t));
                return;
            }
            this._resultPromise.setResult(result);
        }
    }

    private static class ApplyCompletion<R, U>
    extends Completion<R, U> {
        private final Function<? super R, ? extends U> _fn;
        private final PromiseImpl<U> _resultPromise = new PromiseImpl();

        ApplyCompletion(Function<? super R, ? extends U> fn, Dispatcher dispatcher, Completion<R, ?> next) {
            super(dispatcher, next);
            Validate.notNull(fn, (String)"fn");
            this._fn = fn;
        }

        @Override
        Promise<U> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            U result;
            try {
                result = this._fn.apply(value);
            }
            catch (Throwable t) {
                LOGGER.warn("Function '{}' failed.", this._fn, (Object)t);
                this._resultPromise.setError(Exceptions.wrap(t));
                return;
            }
            this._resultPromise.setResult(result);
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setError(err);
        }
    }

    private static class ComposeCompletion<R, U>
    extends Completion<R, U> {
        private final Function<? super R, ? extends Promise<? extends U>> _fn;
        private final PromiseImpl<U> _resultPromise = new PromiseImpl();

        ComposeCompletion(Function<? super R, ? extends Promise<? extends U>> fn, Dispatcher dispatcher, Completion<R, ?> next) {
            super(dispatcher, next);
            Validate.notNull(fn, (String)"fn");
            this._fn = fn;
        }

        @Override
        Promise<U> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            Promise<U> then;
            try {
                then = this._fn.apply(value);
                Validate.notNull(then, (String)"then");
            }
            catch (Throwable t) {
                LOGGER.warn("Function '{}' failed.", this._fn, (Object)t);
                this._resultPromise.setError(Exceptions.wrap(t));
                return;
            }
            then.onError(this._resultPromise::setError);
            then.onSuccess(this._resultPromise::setResult);
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setError(err);
        }
    }

    private static class ErrorCompletion<R>
    extends Completion<R, R> {
        private final Consumer<Exception> _consumer;
        private final PromiseImpl<R> _resultPromise = new PromiseImpl();

        ErrorCompletion(Consumer<Exception> consumer, Dispatcher dispatcher, Completion<R, ?> next) {
            super(dispatcher, next);
            Validate.notNull(consumer, (String)"consumer");
            this._consumer = consumer;
        }

        @Override
        Promise<R> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            this._resultPromise.setResult(value);
        }

        @Override
        void complete(Exception err) {
            try {
                this._consumer.accept(err);
            }
            catch (Throwable t) {
                LOGGER.warn("Consumer '{}' failed.", this._consumer, (Object)t);
            }
            this._resultPromise.setError(err);
        }
    }

    private static class SuccessCompletion<R>
    extends Completion<R, R> {
        private final Consumer<R> _consumer;
        private final PromiseImpl<R> _resultPromise = new PromiseImpl();

        SuccessCompletion(Consumer<R> consumer, Dispatcher dispatcher, Completion<R, ?> next) {
            super(dispatcher, next);
            Validate.notNull(consumer, (String)"consumer");
            this._consumer = consumer;
        }

        @Override
        Promise<R> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            try {
                this._consumer.accept(value);
            }
            catch (Throwable t) {
                LOGGER.warn("Consumer '{}' failed.", this._consumer, (Object)t);
            }
            this._resultPromise.setResult(value);
        }

        @Override
        void complete(Exception err) {
            this._resultPromise.setError(err);
        }
    }

    private static class SubscriberCompletion<R>
    extends Completion<R, R> {
        private final Subscriber<? super R> _subscriber;
        private final PromiseImpl<R> _resultPromise = new PromiseImpl();

        SubscriberCompletion(Subscriber<? super R> subscriber, Dispatcher dispatcher, Completion<R, ?> next) {
            super(dispatcher, next);
            this._subscriber = new SubscriberWrapper<R>(subscriber);
        }

        @Override
        Promise<R> getResultPromise() {
            return this._resultPromise;
        }

        @Override
        void complete(R value) {
            try {
                this._subscriber.onNext(value);
                this._subscriber.onComplete(false);
            }
            catch (Throwable t) {
                LOGGER.warn("Subscriber '{}' failed.", this._subscriber, (Object)t);
            }
            this._resultPromise.setResult(value);
        }

        @Override
        void complete(Exception err) {
            try {
                this._subscriber.onError(err);
            }
            catch (Throwable t) {
                LOGGER.warn("Subscriber '{}' failed.", this._subscriber, (Object)t);
            }
            this._resultPromise.setError(err);
        }

        void cancel() {
            this._subscriber.onComplete(true);
        }
    }

    static abstract class Completion<R, S> {
        private final Dispatcher _dispatcher;
        private final ThreadContext _context;
        private final Completion<R, ?> _next;
        private final AtomicBoolean _completed = new AtomicBoolean(false);

        protected Completion(Dispatcher dispatcher, Completion<R, ?> next) {
            this._dispatcher = dispatcher;
            this._next = next;
            this._context = ThreadContext.get();
        }

        final boolean setResult(Result<R> result) {
            if (this._completed.compareAndSet(false, true)) {
                this._dispatcher.dispatch(() -> ThreadContext.setupContext(() -> result.complete(this), (ThreadContext)this._context));
                return true;
            }
            return false;
        }

        abstract Promise<S> getResultPromise();

        abstract void complete(R var1);

        abstract void complete(Exception var1);
    }

    private static final class Result<T> {
        final T value;
        final Exception err;

        Result(T value) {
            this.value = value;
            this.err = null;
        }

        Result(Exception err) {
            Validate.notNull((Object)err);
            this.err = err;
            this.value = null;
        }

        void complete(Completion<T, ?> c) {
            if (this.err == null) {
                c.complete(this.value);
            } else {
                c.complete(this.err);
            }
        }
    }
}

