/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.reactive.impl;

import com.vmware.dr.ui.tools.reactive.Dispatcher;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.Subscription;
import com.vmware.dr.ui.tools.reactive.impl.AsyncDispatcherImpl;
import com.vmware.dr.ui.tools.reactive.impl.SubscriberWrapper;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;

public class PublisherImpl<T>
implements Publisher<T> {
    private final Set<Subscriber<T>> _toNotify = new CopyOnWriteArraySet<Subscriber<T>>();
    private final AtomicReference<Result> _resultRef = new AtomicReference();
    private final Dispatcher _dispatcher;

    public PublisherImpl() {
        this(new AsyncDispatcherImpl());
    }

    public PublisherImpl(Dispatcher dispatcher) {
        Validate.notNull((Object)dispatcher, (String)"dispatcher");
        this._dispatcher = dispatcher;
    }

    @Override
    public Subscription<T> subscribe(final Subscriber<? super T> subscriber) {
        SubscriberWrapper wrapped = new SubscriberWrapper<T>(subscriber){

            public boolean equals(Object obj) {
                return this._delegate.equals(obj);
            }

            public int hashCode() {
                return this._delegate.hashCode();
            }
        };
        Result result = this._resultRef.get();
        if (result != null) {
            result.complete(wrapped);
        } else {
            if (!this._toNotify.add(wrapped)) {
                throw new IllegalArgumentException(subscriber + " already added.");
            }
            result = this._resultRef.get();
            if (result != null) {
                this._toNotify.remove(wrapped);
                result.complete(wrapped);
            }
        }
        return new SubscriptionImpl(wrapped){

            @Override
            public Subscriber<? super T> getSubscriber() {
                return subscriber;
            }
        };
    }

    public void publishNext(T item) {
        if (this._resultRef.get() != null) {
            return;
        }
        this._dispatcher.dispatch(() -> this._toNotify.forEach(s -> s.onNext(item)));
    }

    public void publishComplete() {
        this.doCompete(new Result());
    }

    public void publishError(Exception err) {
        this.doCompete(new Result(err));
    }

    public boolean isComplete() {
        return this._resultRef.get() != null;
    }

    private void doCompete(Result result) {
        if (this._resultRef.compareAndSet(null, result)) {
            this._dispatcher.dispatch(() -> {
                this._toNotify.forEach(result::complete);
                this._toNotify.clear();
            });
        }
    }

    private abstract class SubscriptionImpl
    implements Subscription<T> {
        final AtomicBoolean _cancelled = new AtomicBoolean(false);
        final Subscriber<T> _subscriber;

        SubscriptionImpl(Subscriber<T> subscriber) {
            this._subscriber = subscriber;
        }

        @Override
        public void cancel() {
            if (!this._cancelled.compareAndSet(false, true)) {
                return;
            }
            this._subscriber.onComplete(true);
            PublisherImpl.this._toNotify.remove(this._subscriber);
        }

        @Override
        public Publisher<T> getPublisher() {
            return PublisherImpl.this;
        }
    }

    private static final class Result {
        final Exception err;

        Result() {
            this.err = null;
        }

        Result(Exception err) {
            this.err = err;
        }

        <T> void complete(Subscriber<T> s) {
            if (this.err == null) {
                s.onComplete(false);
            } else {
                s.onError(this.err);
            }
        }
    }
}

