/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public class RotationManager<T> {
    private final T[] _items;
    private final AtomicInteger _current = new AtomicInteger(0);
    private final Set<T> _set = new HashSet<T>();
    private Integer _hashCode = null;

    public static <T> boolean shift(Rotation<T> rotation, int number) {
        Validate.notNull(rotation, (String)"rotation");
        while (!rotation.endReached() && number > 0) {
            rotation.rotate();
            --number;
        }
        return number == 0;
    }

    private static int indexOf(Object item, Object[] arr) throws UnknownItemException {
        Validate.notNull((Object)item, (String)"item");
        Validate.notEmpty((Object[])arr, (String)"arr");
        int index = ArrayUtils.indexOf((Object[])arr, (Object)item);
        if (index < 0) {
            throw new UnknownItemException(item);
        }
        return index;
    }

    public RotationManager(Set<T> items) {
        Validate.notEmpty(items, (String)"items");
        T first = items.iterator().next();
        this._items = (Object[])Array.newInstance(first.getClass(), items.size());
        items.toArray(this._items);
        this._set.addAll(items);
    }

    public Set<T> getItems() {
        return new HashSet<T>(Arrays.asList(this._items));
    }

    public T getCurrentStart() {
        return this._items[this._current.get()];
    }

    public Rotation<T> create() {
        return new Rotation<T>(this, this._items, this._current.get());
    }

    boolean rotatePast(T item) throws UnknownItemException {
        Validate.notNull(item, (String)"item");
        int index = RotationManager.indexOf(item, this._items);
        int newIndex = (index + 1) % this._items.length;
        return this._current.compareAndSet(index, newIndex);
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = HashUtils.getHashCode(this._items);
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationManager)) {
            return false;
        }
        RotationManager other = (RotationManager)obj;
        return HashUtils.areEqual(this._set, other._set);
    }

    public String toString() {
        HashMap<String, Object> members = new HashMap<String, Object>();
        members.put("_items", this._items);
        return StringUtils.getToStringValue("RotationManager", members);
    }

    public static class Rotation<T> {
        private final RotationManager<T> _manager;
        private final T[] _items;
        private final T _startItem;
        private final AtomicInteger _index = new AtomicInteger(0);

        Rotation(RotationManager<T> manager, T[] items, int startIndex) throws UnknownItemException {
            this._startItem = items[startIndex];
            this._items = Arrays.copyOf(items, items.length);
            if (startIndex > 0) {
                System.arraycopy(items, startIndex, this._items, 0, items.length - startIndex);
                System.arraycopy(items, 0, this._items, items.length - startIndex, startIndex);
            }
            this._manager = manager;
        }

        public T getStartItem() {
            return this._startItem;
        }

        public T getCurrent() {
            return this._items[this._index.get()];
        }

        public T rotate() {
            int current = this._index.get();
            if (current == this._items.length - 1) {
                return null;
            }
            if (this._index.compareAndSet(current++, current)) {
                T result = this._items[current];
                this._manager.rotatePast(result);
                return result;
            }
            return null;
        }

        public T peekNext() {
            int index = this._index.get();
            if (index == this._items.length - 1) {
                return null;
            }
            return this._items[index + 1];
        }

        public boolean endReached() {
            return this._index.get() == this._items.length - 1;
        }
    }

    public static class UnknownItemException
    extends RuntimeException {
        private static final long serialVersionUID = 2292173007479187922L;

        UnknownItemException(Object unknown) {
            super("Unknown item: " + unknown);
        }
    }
}

