/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;

public class ConfigurableSSLSocketFactory
extends SSLSocketFactory {
    protected final SSLSocketFactory delegate;

    public ConfigurableSSLSocketFactory(SSLSocketFactory delegate) {
        if (delegate == null) {
            throw new NullPointerException("'delegate' cannot be null");
        }
        this.delegate = delegate;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.configureSocket(this.delegate.createSocket());
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.configureSocket(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.configureSocket(this.delegate.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.configureSocket(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.configureSocket(this.delegate.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        return this.configureSocket(this.delegate.createSocket(s, consumed, autoClose));
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.configureSocket(this.delegate.createSocket(s, host, port, autoClose));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    protected Socket configureSocket(Socket s) {
        return s;
    }
}

