/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.authentication.CsrfGuard;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.infrastructure.authentication.data.SessionStatusData;
import com.vmware.srm.client.infrastructure.http.AsyncController;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.topology.impl.init.Config;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionInfoServlet
extends HttpServlet {
    protected void doPost(final HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!CsrfGuard.enforce((ServletRequest)request, (ServletResponse)response, false)) {
            return;
        }
        AsyncController<FreeRequestContext> controller = new AsyncController<FreeRequestContext>(request, response, null){

            @Override
            protected Promise<DrData> getResponseValue(DrData input, FreeRequestContext context) {
                if (!AuthenticationUtils.isAuthenticated(request)) {
                    return Promises.resolve((Object)new SessionStatusData(false, null));
                }
                String username = SessionWrapper.getUsername(request.getSession(false));
                return Promises.resolve((Object)new SessionStatusData(true, username));
            }

            @Override
            protected Promise<? extends FreeRequestContext> getContext() {
                return Promises.resolve(null);
            }
        };
        controller.start(Config.get().getResponseTimeout());
    }
}

