/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.health;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.identity.websso.client.LogonProcessor;
import com.vmware.identity.websso.client.LogonProcessorEx;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageStoreImpl;
import com.vmware.identity.websso.client.SsoRequestSettings;
import com.vmware.identity.websso.client.endpoint.SsoRequestSender;
import com.vmware.srm.client.infrastructure.http.io.HttpResponseController;
import com.vmware.srm.client.infrastructure.websso.LsppUtils;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class WebSSORegChecker {
    WebSSORegChecker() {
    }

    Promise<Boolean> doCheck(SsoContext ssoContext) {
        return Promises.resolve((Object)ssoContext).thenCompose(context -> {
            KeyStore store;
            URI requestUrl;
            SsoRequestSender sender;
            ProcessorImpl process = new ProcessorImpl();
            try {
                sender = this.createSender(ssoContext, process);
            }
            catch (NoSuchAlgorithmException exc) {
                return Promises.reject((Exception)exc);
            }
            String request = sender.getRequestUrl(this.createRequestSettings((SsoContext)context));
            Exception processExc = process.getError();
            if (processExc != null) {
                return Promises.reject((Exception)processExc);
            }
            try {
                requestUrl = new URI(request);
            }
            catch (URISyntaxException exc) {
                return Promises.reject((Exception)exc);
            }
            LsppServiceEndpoint se = LsppUtils.getEndpoint(context.getSsoRegistration(), LsppUtils.WEBSSO);
            if (se == null) {
                throw new IllegalArgumentException("No WebSSO endpoint in " + context.getSsoRegistration());
            }
            try {
                store = CertificateUtils.createTrustStore((Collection)se.getCertificates());
            }
            catch (Exception exc) {
                return Promises.reject((Exception)exc);
            }
            SslTrust.TrustData td = SslTrust.get((KeyStore)store);
            return HttpResponseController.doGet(requestUrl, (KeyStore)td.second(), (ThumbprintVerifier)td.first()).thenApply(response -> {
                int code = response.getStatusLine().getStatusCode();
                if (code != 200) {
                    throw new RuntimeException("WebSSO response code " + code);
                }
                return true;
            });
        });
    }

    private SsoRequestSender createSender(SsoContext context, LogonProcessorEx processor) throws NoSuchAlgorithmException {
        SsoRequestSender requestSender = new SsoRequestSender();
        requestSender.setLogonProcessor((LogonProcessor)processor);
        requestSender.setMessageStore((MessageStore)new MessageStoreImpl());
        requestSender.setMetadataSettings(context.getMetadataSettings());
        return requestSender;
    }

    private SsoRequestSettings createRequestSettings(SsoContext context) {
        SsoRequestSettings result = new SsoRequestSettings(context.getSpConfig().getAlias(), context.getIDPConfig().getAlias());
        result.setIsRenewable(Boolean.valueOf(true));
        result.setIsDelegable(Boolean.valueOf(true));
        result.setIsSigned(Boolean.valueOf(true));
        return result;
    }

    private static final class ProcessorImpl
    implements LogonProcessorEx {
        private Exception _exc;

        private ProcessorImpl() {
        }

        public void authenticationError(Message message, HttpServletRequest request, HttpServletResponse response) {
            this._exc = new RuntimeException("WebSSO client authentication error");
        }

        public void authenticationSuccess(Message message, HttpServletRequest request, HttpServletResponse response) {
        }

        public void internalError(Exception exc, HttpServletRequest request, HttpServletResponse response) {
            this._exc = new RuntimeException("WebSSO client internal  error", exc);
        }

        public void authenticationError(Message message, Locale locale, String paramString, HttpServletRequest request, HttpServletResponse response) {
            this._exc = new RuntimeException("WebSSO client authentication error");
        }

        public void authenticationSuccess(Message message, Locale locale, String paramString, HttpServletRequest request, HttpServletResponse response) {
        }

        public void internalError(Exception exc, Locale locale, String paramString, HttpServletRequest request, HttpServletResponse response) {
            this._exc = new RuntimeException("WebSSO client internal  error", exc);
        }

        Exception getError() {
            return this._exc;
        }
    }
}

