/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.navigation;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.srm.client.infrastructure.commonData.WarnServerType;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.DrSitePairBuilder;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.CertificateWarningData;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.DrSitePair;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.RoboPair;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.ServerInfo;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.ServerPair;
import com.vmware.srm.client.infrastructure.requestHandlers.navigation.data.ServerStatus;
import com.vmware.srm.client.topology.client.view.Server;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServersView;
import com.vmware.srm.client.topology.client.view.certificate.CertificateValidityInfo;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.impl.init.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitePairHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SitePairHelper.class);
    private final String _hostServerGuid;
    private final Comparator<DrSitePair> _drSitePairComparator = new DrSitePairComparator();
    private final Comparator<ServerPair> _serverPairComparator = new ServerPairComparator();
    private final Comparator<RoboPair> _roboPairComparator = new RoboPairComparator();

    private static int compare(String name1, String name2, String pairName1, String pairName2) {
        int result = name1.compareTo(name2);
        if (result != 0) {
            return result;
        }
        return pairName1.compareTo(pairName2);
    }

    SitePairHelper() {
        this._hostServerGuid = Config.get().getServerGuid();
    }

    private boolean isHostServer(ServerInfo si) {
        return si.getGuid().equals(this._hostServerGuid);
    }

    private boolean containsHostServer(ServerPair sp) {
        return this.isHostServer(sp.getServer()) || this.isHostServer(sp.getPairServer());
    }

    private boolean containsHostServer(DrSitePair dsp) {
        if (dsp.getHmsPair() != null && this.containsHostServer(dsp.getHmsPair())) {
            return true;
        }
        if (dsp.getSrmPairs() != null) {
            return dsp.getSrmPairs().stream().anyMatch(this::containsHostServer);
        }
        return false;
    }

    Promise<List<DrSitePair>> getDrSitePairs(ServersView view) {
        Promise<List<VcExtPair>> srmPairs = this.getAllSrmPairs((SrmServersView)view);
        Promise<List<VcExtPair>> hmsPairs = this.getAllHmsPairs((HmsServersView)view);
        Promise<String> vcGuidBias = this.getVcGuidBias((ExtensionServersView)view);
        return Promises.all((Promise[])new Promise[]{srmPairs, hmsPairs, vcGuidBias}).thenApply(ra -> {
            List<DrSitePair> pairs = this.getSitePairs((List)ra.getResult(srmPairs), (List)ra.getResult(hmsPairs), (String)ra.getResult(vcGuidBias));
            pairs.sort(this._drSitePairComparator);
            return pairs;
        });
    }

    Promise<List<RoboPair>> getRoboPairs(ServersView view) {
        HmsServersView hmsView = (HmsServersView)view;
        if (!Config.get().getRoboEnabled()) {
            return Promises.resolve(Collections.emptyList());
        }
        return hmsView.getLocalHmsServers().flatMap(hms -> this.getVcExtPairs((ExtensionServer<?>)hms).filter(vex -> {
            ServerInfo si = vex.getExtPair().getServer();
            ServerInfo pairSi = vex.getExtPair().getPairServer();
            return si.equals(pairSi);
        }).materialize().flatMap(event -> {
            switch (event.type) {
                case error: {
                    LOGGER.warn("Fail to get HMS sitePairData for {}: ", hms, (Object)event.error);
                }
                case complete: {
                    return Streams.empty();
                }
            }
            return Streams.just((Object[])new VcExtPair[]{(VcExtPair)event.item});
        })).reduce(new ArrayList(), (list, vex) -> {
            RoboPair rp = new RoboPair();
            rp.setVc(vex.getVcPair().getServer());
            rp.setHms(vex.getExtPair().getServer());
            list.add(rp);
            return list;
        }).thenApply(robos -> {
            robos.sort(this._roboPairComparator);
            return robos;
        });
    }

    static UnorderedKey getGroupByPairsUnorderedKey(VcExtPair vex) {
        String vcGuid = vex.getVcPair().getServer().getGuid();
        String pairVcGuid = vex.getVcPair().getPairServer().getGuid();
        String extGuid = vex.getExtPair().getServer().getGuid();
        String pairExtGuid = vex.getExtPair().getPairServer().getGuid();
        return new UnorderedKey(vcGuid, pairVcGuid, extGuid, pairExtGuid);
    }

    private UnorderedKey getGroupByVcGuidsUnorderedKey(VcExtPair vex) {
        ServerPair vcPair = vex.getVcPair();
        return new UnorderedKey(vcPair.getServer().getGuid(), vcPair.getPairServer().getGuid());
    }

    private Promise<String> getVcGuidBias(ExtensionServersView view) {
        if (this._hostServerGuid == null) {
            LOGGER.warn("Host server guid is not configured.");
            return Promises.resolve(null);
        }
        return view.getServerBy(this._hostServerGuid).thenApply(ExtensionServer.class::cast).materialize().thenApply(pr -> {
            if (pr.isSuccessful()) {
                return ((ExtensionServer)pr.getResult()).vc().guid();
            }
            LOGGER.warn("Unable to get server by guid: '{}'.", (Object)this._hostServerGuid, (Object)pr.getError());
            return null;
        });
    }

    private List<DrSitePair> getSitePairs(List<VcExtPair> srmPairs, List<VcExtPair> hmsPairs, String vcGuidBias) {
        List<VcExtPair> hmsesUnordered;
        Map<UnorderedKey, List<VcExtPair>> srmsByVcGuidUnordered = srmPairs.stream().collect(Collectors.groupingBy(this::getGroupByVcGuidsUnorderedKey));
        Map<UnorderedKey, List<VcExtPair>> hmsesByVcGuidUnordered = hmsPairs.stream().collect(Collectors.groupingBy(this::getGroupByVcGuidsUnorderedKey));
        ArrayList<DrSitePair> result = new ArrayList<DrSitePair>();
        for (Map.Entry<UnorderedKey, List<VcExtPair>> entrySrmByVcGuidUnordered : srmsByVcGuidUnordered.entrySet()) {
            hmsesUnordered = hmsesByVcGuidUnordered.remove(entrySrmByVcGuidUnordered.getKey());
            if (hmsesUnordered == null) {
                hmsesUnordered = Collections.emptyList();
            }
            List<VcExtPair> srmsUnordered = entrySrmByVcGuidUnordered.getValue();
            DrSitePairBuilder builder = null;
            for (VcExtPair srmPair : srmsUnordered) {
                if (builder == null) {
                    ServerPair vcPair = srmPair.getVcPair();
                    builder = new DrSitePairBuilder(vcPair.getServer().getGuid(), vcPair.getPairServer().getGuid(), vcGuidBias);
                }
                builder.addSrm(srmPair);
            }
            for (VcExtPair hmsPair : hmsesUnordered) {
                builder.addHms(hmsPair);
            }
            for (DrSitePair dsp : builder.build()) {
                dsp.getSrmPairs().sort(this._serverPairComparator);
                result.add(dsp);
            }
        }
        for (Map.Entry<UnorderedKey, List<VcExtPair>> entryHmsByVcGuidUnordered : hmsesByVcGuidUnordered.entrySet()) {
            hmsesUnordered = entryHmsByVcGuidUnordered.getValue();
            DrSitePairBuilder builder = null;
            for (VcExtPair hmsPair : hmsesUnordered) {
                if (builder == null) {
                    ServerPair vcPair = hmsPair.getVcPair();
                    builder = new DrSitePairBuilder(vcPair.getServer().getGuid(), vcPair.getPairServer().getGuid(), vcGuidBias);
                }
                builder.addHms(hmsPair);
            }
            result.addAll(builder.build());
        }
        return result;
    }

    private Promise<List<VcExtPair>> getAllSrmPairs(SrmServersView view) {
        return view.getLocalSrmServers().flatMap(srm -> this.getVcExtPairs((ExtensionServer<?>)srm).materialize().flatMap(event -> {
            switch (event.type) {
                case error: {
                    LOGGER.warn("Fail to get SRM sitePairData for {}: ", srm, (Object)event.error);
                }
                case complete: {
                    return Streams.empty();
                }
            }
            return Streams.just((Object[])new VcExtPair[]{(VcExtPair)event.item});
        })).collect().thenApply(ArrayList::new);
    }

    private Promise<List<VcExtPair>> getAllHmsPairs(HmsServersView view) {
        return view.getLocalHmsServers().flatMap(hms -> this.getVcExtPairs((ExtensionServer<?>)hms).filter(vex -> {
            ServerInfo pairSi;
            ServerInfo si = vex.getExtPair().getServer();
            return !si.equals(pairSi = vex.getExtPair().getPairServer());
        }).materialize().flatMap(event -> {
            switch (event.type) {
                case error: {
                    LOGGER.warn("Fail to get HMS sitePairData for {}: ", hms, (Object)event.error);
                }
                case complete: {
                    return Streams.empty();
                }
            }
            return Streams.just((Object[])new VcExtPair[]{(VcExtPair)event.item});
        })).collect().thenApply(ArrayList::new);
    }

    private Stream<VcExtPair> getVcExtPairs(ExtensionServer<?> extServer) {
        Promise<ServerInfo> vcInfo = this.getServerInfo((Server<?>)extServer.vc());
        Promise<ServerInfo> extInfo = this.getServerInfo((Server<?>)extServer);
        return extServer.getPairs().flatMap(ps -> {
            Promise<ServerInfo> pairVcInfo = this.createPairVcInfo((PairSetup<?>)ps);
            Promise vcApplier = vcInfo.thenCombine(pairVcInfo, ServerPair::new).thenApply(sp -> vex -> vex.setVcPair((ServerPair)sp));
            Promise<ServerInfo> pairExtInfo = this.createPairExtInfo((PairSetup<?>)ps);
            Promise extApplier = extInfo.thenCombine(pairExtInfo, ServerPair::new).thenApply(sp -> vex -> vex.setExtPair((ServerPair)sp));
            return Streams.from((Publisher[])new Publisher[]{vcApplier, extApplier}).reduce((Object)new VcExtPair(), (vex, consumer) -> {
                consumer.accept(vex);
                return vex;
            });
        });
    }

    private Promise<ServerInfo> getServerInfo(Server<?> server) {
        return server.getName().materialize().thenApply(result -> {
            ServerStatus status;
            String name;
            if (result.isSuccessful()) {
                name = (String)result.getResult();
                status = ServerStatus.OK;
            } else {
                name = server.url().getHost();
                status = ServerStatus.WARNING;
            }
            return new ServerInfo(server.guid(), name, status, this.getServerWarnings(server));
        });
    }

    private Promise<ServerInfo> createPairVcInfo(PairSetup<?> ps) {
        Promise pairVcPromise = ps.getPairServer().thenApply(ExtensionServer::vc);
        ServerInfo serverInfo = new ServerInfo(ps.pairVcGuid(), ps.pairVcName());
        return this.getServerInfoPromise(serverInfo, (Promise<Server.Status>)pairVcPromise.thenCompose(Server::getStatus), pairVcPromise);
    }

    private Promise<ServerInfo> createPairExtInfo(PairSetup<?> ps) {
        Promise pairServerPromise = ps.getPairServer();
        ServerInfo serverInfo = new ServerInfo(ps.pairServerGuid(), ps.pairServerName());
        return this.getServerInfoPromise(serverInfo, (Promise<Server.Status>)pairServerPromise.thenCompose(Server::getStatus), pairServerPromise);
    }

    private Promise<ServerInfo> getServerInfoPromise(ServerInfo serverInfo, Promise<Server.Status> statusPromise, Promise<Server<?>> serverPromise) {
        Promise statusConsumer = statusPromise.materialize().thenApply(pr -> si -> si.setStatus(this.getServerStatus((PromiseResult<Server.Status>)pr)));
        Promise serverWarningsConsumer = serverPromise.materialize().thenApply(pr -> si -> si.setCertificateWarnings(this.getServerWarnings((PromiseResult<?>)pr)));
        return Streams.from((Publisher[])new Publisher[]{statusConsumer, serverWarningsConsumer}).reduce((Object)serverInfo, (si, consumer) -> {
            consumer.accept(si);
            return si;
        });
    }

    private ServerStatus getServerStatus(PromiseResult<Server.Status> result) {
        Server.Status ss;
        ServerStatus status = result.isSuccessful() ? ((ss = (Server.Status)result.getResult()) == Server.Status.ok ? ServerStatus.OK : ServerStatus.WARNING) : ServerStatus.WARNING;
        return status;
    }

    private List<CertificateWarningData> getServerWarnings(PromiseResult<?> serverResult) {
        if (!serverResult.isSuccessful()) {
            return Collections.emptyList();
        }
        Server server = (Server)serverResult.getResult();
        return this.getServerWarnings(server);
    }

    private List<CertificateWarningData> getServerWarnings(Server<?> server) {
        List infos = server.certificateIssues();
        if (CollectionUtils.isEmpty((Collection)infos)) {
            return Collections.emptyList();
        }
        return infos.stream().filter(info -> info.getStatus() == CertificateValidityInfo.Status.AboutToExpire).map(validityInfo -> new CertificateWarningData(this.getServerType(server), server.guid(), server.url().getHost(), (CertificateValidityInfo)validityInfo)).collect(Collectors.toList());
    }

    private WarnServerType getServerType(Server<?> server) {
        if (server instanceof VcServer) {
            return WarnServerType.VC;
        }
        if (server instanceof HmsServer) {
            return WarnServerType.HMS;
        }
        return WarnServerType.SRM;
    }

    private final class RoboPairComparator
    implements Comparator<RoboPair> {
        private RoboPairComparator() {
        }

        @Override
        public int compare(RoboPair rp1, RoboPair rp2) {
            if (SitePairHelper.this.isHostServer(rp1.getHms())) {
                return -1;
            }
            if (SitePairHelper.this.isHostServer(rp2.getHms())) {
                return 1;
            }
            String vc1 = rp1.getVc().getName();
            String vc2 = rp2.getVc().getName();
            return vc1.compareTo(vc2);
        }
    }

    private final class DrSitePairComparator
    implements Comparator<DrSitePair> {
        private DrSitePairComparator() {
        }

        @Override
        public int compare(DrSitePair dsp1, DrSitePair dsp2) {
            if (SitePairHelper.this.containsHostServer(dsp1)) {
                return -1;
            }
            if (SitePairHelper.this.containsHostServer(dsp2)) {
                return 1;
            }
            ServerPair vcs1 = dsp1.getVcPair();
            ServerPair vcs2 = dsp2.getVcPair();
            return SitePairHelper.compare(vcs1.getServer().getName(), vcs2.getServer().getName(), vcs1.getPairServer().getName(), vcs2.getPairServer().getName());
        }
    }

    private final class ServerPairComparator
    implements Comparator<ServerPair> {
        private ServerPairComparator() {
        }

        @Override
        public int compare(ServerPair sp1, ServerPair sp2) {
            if (SitePairHelper.this.containsHostServer(sp1)) {
                return -1;
            }
            if (SitePairHelper.this.containsHostServer(sp2)) {
                return 1;
            }
            return SitePairHelper.compare(sp1.getServer().getName(), sp2.getServer().getName(), sp1.getPairServer().getName(), sp2.getPairServer().getName());
        }
    }

    public class VcExtPair {
        private ServerPair _vcPair;
        private ServerPair _extPair;

        public ServerPair getVcPair() {
            return this._vcPair;
        }

        public ServerPair getExtPair() {
            return this._extPair;
        }

        public void setVcPair(ServerPair vcPair) {
            this._vcPair = vcPair;
        }

        public void setExtPair(ServerPair extPair) {
            this._extPair = extPair;
        }
    }

    static final class UnorderedKey {
        private final Set<String> _set;
        private final int _hashCode;

        UnorderedKey(String ... fields) {
            Validate.notEmpty((Object[])fields, (String)"fields");
            this._set = new HashSet<String>(Arrays.asList(fields));
            this._hashCode = HashUtils.getHashCode((Object[])new Object[]{this._set});
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnorderedKey other = (UnorderedKey)obj;
            return HashUtils.areEqual((Object)this._set.size(), (Object)other._set.size()) && HashUtils.areEqual(this._set, other._set);
        }
    }
}

